/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResolverKind {
    UNIT("UNIT"),
    PIPELINE("PIPELINE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResolverKind> VALUE_MAP;
    private final String value;

    private ResolverKind(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResolverKind fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResolverKind> knownValues() {
        EnumSet<ResolverKind> knownValues = EnumSet.allOf(ResolverKind.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResolverKind.class, ResolverKind::toString);
    }
}

