/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiKey> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ApiKey.getter(ApiKey::id)).setter(ApiKey.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ApiKey.getter(ApiKey::description)).setter(ApiKey.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Long> EXPIRES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("expires").getter(ApiKey.getter(ApiKey::expires)).setter(ApiKey.setter(Builder::expires)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expires").build()}).build();
    private static final SdkField<Long> DELETES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("deletes").getter(ApiKey.getter(ApiKey::deletes)).setter(ApiKey.setter(Builder::deletes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD, EXPIRES_FIELD, DELETES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String description;
    private final Long expires;
    private final Long deletes;

    private ApiKey(BuilderImpl builder) {
        this.id = builder.id;
        this.description = builder.description;
        this.expires = builder.expires;
        this.deletes = builder.deletes;
    }

    public final String id() {
        return this.id;
    }

    public final String description() {
        return this.description;
    }

    public final Long expires() {
        return this.expires;
    }

    public final Long deletes() {
        return this.deletes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.expires());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiKey)) {
            return false;
        }
        ApiKey other = (ApiKey)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.expires(), other.expires()) && Objects.equals(this.deletes(), other.deletes());
    }

    public final String toString() {
        return ToString.builder((String)"ApiKey").add("Id", (Object)this.id()).add("Description", (Object)this.description()).add("Expires", (Object)this.expires()).add("Deletes", (Object)this.deletes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "expires": {
                return Optional.ofNullable(clazz.cast(this.expires()));
            }
            case "deletes": {
                return Optional.ofNullable(clazz.cast(this.deletes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApiKey, T> g) {
        return obj -> g.apply((ApiKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String description;
        private Long expires;
        private Long deletes;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiKey model) {
            this.id(model.id);
            this.description(model.description);
            this.expires(model.expires);
            this.deletes(model.deletes);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Long getExpires() {
            return this.expires;
        }

        public final void setExpires(Long expires) {
            this.expires = expires;
        }

        @Override
        public final Builder expires(Long expires) {
            this.expires = expires;
            return this;
        }

        public final Long getDeletes() {
            return this.deletes;
        }

        public final void setDeletes(Long deletes) {
            this.deletes = deletes;
        }

        @Override
        public final Builder deletes(Long deletes) {
            this.deletes = deletes;
            return this;
        }

        public ApiKey build() {
            return new ApiKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiKey> {
        public Builder id(String var1);

        public Builder description(String var1);

        public Builder expires(Long var1);

        public Builder deletes(Long var1);
    }
}

