/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAppBlockBuilderRequest extends AppStreamRequest implements
        ToCopyableBuilder<UpdateAppBlockBuilderRequest.Builder, UpdateAppBlockBuilderRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateAppBlockBuilderRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateAppBlockBuilderRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(UpdateAppBlockBuilderRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Platform").getter(getter(UpdateAppBlockBuilderRequest::platformAsString))
            .setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(UpdateAppBlockBuilderRequest::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(UpdateAppBlockBuilderRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<Boolean> ENABLE_DEFAULT_INTERNET_ACCESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableDefaultInternetAccess")
            .getter(getter(UpdateAppBlockBuilderRequest::enableDefaultInternetAccess))
            .setter(setter(Builder::enableDefaultInternetAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDefaultInternetAccess")
                    .build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(UpdateAppBlockBuilderRequest::iamRoleArn))
            .setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<List<AccessEndpoint>> ACCESS_ENDPOINTS_FIELD = SdkField
            .<List<AccessEndpoint>> builder(MarshallingType.LIST)
            .memberName("AccessEndpoints")
            .getter(getter(UpdateAppBlockBuilderRequest::accessEndpoints))
            .setter(setter(Builder::accessEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ATTRIBUTES_TO_DELETE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AttributesToDelete")
            .getter(getter(UpdateAppBlockBuilderRequest::attributesToDeleteAsStrings))
            .setter(setter(Builder::attributesToDeleteWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            DISPLAY_NAME_FIELD, PLATFORM_FIELD, INSTANCE_TYPE_FIELD, VPC_CONFIG_FIELD, ENABLE_DEFAULT_INTERNET_ACCESS_FIELD,
            IAM_ROLE_ARN_FIELD, ACCESS_ENDPOINTS_FIELD, ATTRIBUTES_TO_DELETE_FIELD));

    private final String name;

    private final String description;

    private final String displayName;

    private final String platform;

    private final String instanceType;

    private final VpcConfig vpcConfig;

    private final Boolean enableDefaultInternetAccess;

    private final String iamRoleArn;

    private final List<AccessEndpoint> accessEndpoints;

    private final List<String> attributesToDelete;

    private UpdateAppBlockBuilderRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.platform = builder.platform;
        this.instanceType = builder.instanceType;
        this.vpcConfig = builder.vpcConfig;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.iamRoleArn = builder.iamRoleArn;
        this.accessEndpoints = builder.accessEndpoints;
        this.attributesToDelete = builder.attributesToDelete;
    }

    /**
     * <p>
     * The unique name for the app block builder.
     * </p>
     * 
     * @return The unique name for the app block builder.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the app block builder.
     * </p>
     * 
     * @return The description of the app block builder.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The display name of the app block builder.
     * </p>
     * 
     * @return The display name of the app block builder.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The platform of the app block builder.
     * </p>
     * <p>
     * <code>WINDOWS_SERVER_2019</code> is the only valid value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the app block builder.</p>
     *         <p>
     *         <code>WINDOWS_SERVER_2019</code> is the only valid value.
     * @see PlatformType
     */
    public final PlatformType platform() {
        return PlatformType.fromValue(platform);
    }

    /**
     * <p>
     * The platform of the app block builder.
     * </p>
     * <p>
     * <code>WINDOWS_SERVER_2019</code> is the only valid value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the app block builder.</p>
     *         <p>
     *         <code>WINDOWS_SERVER_2019</code> is the only valid value.
     * @see PlatformType
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The instance type to use when launching the app block builder. The following instance types are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * stream.standard.small
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.standard.medium
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.standard.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.standard.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.standard.2xlarge
     * </p>
     * </li>
     * </ul>
     * 
     * @return The instance type to use when launching the app block builder. The following instance types are
     *         available:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         stream.standard.small
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.standard.medium
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.standard.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.standard.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.standard.2xlarge
     *         </p>
     *         </li>
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The VPC configuration for the app block builder.
     * </p>
     * <p>
     * App block builders require that you specify at least two subnets in different availability zones.
     * </p>
     * 
     * @return The VPC configuration for the app block builder.</p>
     *         <p>
     *         App block builders require that you specify at least two subnets in different availability zones.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * Enables or disables default internet access for the app block builder.
     * </p>
     * 
     * @return Enables or disables default internet access for the app block builder.
     */
    public final Boolean enableDefaultInternetAccess() {
        return enableDefaultInternetAccess;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to apply to the app block builder. To assume a role, the app block
     * builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of
     * the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the
     * temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html"
     * >Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming
     * Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to apply to the app block builder. To assume a role, the
     *         app block builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and
     *         passes the ARN of the role to use. The operation creates a new session with temporary credentials.
     *         AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b>
     *         credential profile on the instance.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html"
     *         >Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming
     *         Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessEndpoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessEndpoints() {
        return accessEndpoints != null && !(accessEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the app block
     * builder only through the specified endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessEndpoints} method.
     * </p>
     * 
     * @return The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the app
     *         block builder only through the specified endpoints.
     */
    public final List<AccessEndpoint> accessEndpoints() {
        return accessEndpoints;
    }

    /**
     * <p>
     * The attributes to delete from the app block builder.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributesToDelete} method.
     * </p>
     * 
     * @return The attributes to delete from the app block builder.
     */
    public final List<AppBlockBuilderAttribute> attributesToDelete() {
        return AppBlockBuilderAttributesCopier.copyStringToEnum(attributesToDelete);
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributesToDelete property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributesToDelete() {
        return attributesToDelete != null && !(attributesToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes to delete from the app block builder.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributesToDelete} method.
     * </p>
     * 
     * @return The attributes to delete from the app block builder.
     */
    public final List<String> attributesToDeleteAsStrings() {
        return attributesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessEndpoints() ? accessEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributesToDelete() ? attributesToDeleteAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppBlockBuilderRequest)) {
            return false;
        }
        UpdateAppBlockBuilderRequest other = (UpdateAppBlockBuilderRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(enableDefaultInternetAccess(), other.enableDefaultInternetAccess())
                && Objects.equals(iamRoleArn(), other.iamRoleArn()) && hasAccessEndpoints() == other.hasAccessEndpoints()
                && Objects.equals(accessEndpoints(), other.accessEndpoints())
                && hasAttributesToDelete() == other.hasAttributesToDelete()
                && Objects.equals(attributesToDeleteAsStrings(), other.attributesToDeleteAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAppBlockBuilderRequest").add("Name", name()).add("Description", description())
                .add("DisplayName", displayName()).add("Platform", platformAsString()).add("InstanceType", instanceType())
                .add("VpcConfig", vpcConfig()).add("EnableDefaultInternetAccess", enableDefaultInternetAccess())
                .add("IamRoleArn", iamRoleArn()).add("AccessEndpoints", hasAccessEndpoints() ? accessEndpoints() : null)
                .add("AttributesToDelete", hasAttributesToDelete() ? attributesToDeleteAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "EnableDefaultInternetAccess":
            return Optional.ofNullable(clazz.cast(enableDefaultInternetAccess()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "AccessEndpoints":
            return Optional.ofNullable(clazz.cast(accessEndpoints()));
        case "AttributesToDelete":
            return Optional.ofNullable(clazz.cast(attributesToDeleteAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppBlockBuilderRequest, T> g) {
        return obj -> g.apply((UpdateAppBlockBuilderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAppBlockBuilderRequest> {
        /**
         * <p>
         * The unique name for the app block builder.
         * </p>
         * 
         * @param name
         *        The unique name for the app block builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the app block builder.
         * </p>
         * 
         * @param description
         *        The description of the app block builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name of the app block builder.
         * </p>
         * 
         * @param displayName
         *        The display name of the app block builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The platform of the app block builder.
         * </p>
         * <p>
         * <code>WINDOWS_SERVER_2019</code> is the only valid value.
         * </p>
         * 
         * @param platform
         *        The platform of the app block builder.</p>
         *        <p>
         *        <code>WINDOWS_SERVER_2019</code> is the only valid value.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform of the app block builder.
         * </p>
         * <p>
         * <code>WINDOWS_SERVER_2019</code> is the only valid value.
         * </p>
         * 
         * @param platform
         *        The platform of the app block builder.</p>
         *        <p>
         *        <code>WINDOWS_SERVER_2019</code> is the only valid value.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platform(PlatformType platform);

        /**
         * <p>
         * The instance type to use when launching the app block builder. The following instance types are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * stream.standard.small
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.standard.medium
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.standard.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.standard.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.standard.2xlarge
         * </p>
         * </li>
         * </ul>
         * 
         * @param instanceType
         *        The instance type to use when launching the app block builder. The following instance types are
         *        available:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        stream.standard.small
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.standard.medium
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.standard.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.standard.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.standard.2xlarge
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The VPC configuration for the app block builder.
         * </p>
         * <p>
         * App block builders require that you specify at least two subnets in different availability zones.
         * </p>
         * 
         * @param vpcConfig
         *        The VPC configuration for the app block builder.</p>
         *        <p>
         *        App block builders require that you specify at least two subnets in different availability zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * The VPC configuration for the app block builder.
         * </p>
         * <p>
         * App block builders require that you specify at least two subnets in different availability zones.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * Enables or disables default internet access for the app block builder.
         * </p>
         * 
         * @param enableDefaultInternetAccess
         *        Enables or disables default internet access for the app block builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to apply to the app block builder. To assume a role, the app
         * block builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the
         * ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0
         * retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the
         * instance.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html"
         * >Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming
         * Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * </p>
         * 
         * @param iamRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role to apply to the app block builder. To assume a role,
         *        the app block builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation
         *        and passes the ARN of the role to use. The operation creates a new session with temporary credentials.
         *        AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b>
         *        credential profile on the instance.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html"
         *        >Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming
         *        Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the app block
         * builder only through the specified endpoints.
         * </p>
         * 
         * @param accessEndpoints
         *        The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the app
         *        block builder only through the specified endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints);

        /**
         * <p>
         * The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the app block
         * builder only through the specified endpoints.
         * </p>
         * 
         * @param accessEndpoints
         *        The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the app
         *        block builder only through the specified endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEndpoints(AccessEndpoint... accessEndpoints);

        /**
         * <p>
         * The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the app block
         * builder only through the specified endpoints.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appstream.model.AccessEndpoint.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.appstream.model.AccessEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appstream.model.AccessEndpoint.Builder#build()} is called immediately
         * and its result is passed to {@link #accessEndpoints(List<AccessEndpoint>)}.
         * 
         * @param accessEndpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appstream.model.AccessEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessEndpoints(java.util.Collection<AccessEndpoint>)
         */
        Builder accessEndpoints(Consumer<AccessEndpoint.Builder>... accessEndpoints);

        /**
         * <p>
         * The attributes to delete from the app block builder.
         * </p>
         * 
         * @param attributesToDelete
         *        The attributes to delete from the app block builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDeleteWithStrings(Collection<String> attributesToDelete);

        /**
         * <p>
         * The attributes to delete from the app block builder.
         * </p>
         * 
         * @param attributesToDelete
         *        The attributes to delete from the app block builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDeleteWithStrings(String... attributesToDelete);

        /**
         * <p>
         * The attributes to delete from the app block builder.
         * </p>
         * 
         * @param attributesToDelete
         *        The attributes to delete from the app block builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDelete(Collection<AppBlockBuilderAttribute> attributesToDelete);

        /**
         * <p>
         * The attributes to delete from the app block builder.
         * </p>
         * 
         * @param attributesToDelete
         *        The attributes to delete from the app block builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDelete(AppBlockBuilderAttribute... attributesToDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String displayName;

        private String platform;

        private String instanceType;

        private VpcConfig vpcConfig;

        private Boolean enableDefaultInternetAccess;

        private String iamRoleArn;

        private List<AccessEndpoint> accessEndpoints = DefaultSdkAutoConstructList.getInstance();

        private List<String> attributesToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppBlockBuilderRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            displayName(model.displayName);
            platform(model.platform);
            instanceType(model.instanceType);
            vpcConfig(model.vpcConfig);
            enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            iamRoleArn(model.iamRoleArn);
            accessEndpoints(model.accessEndpoints);
            attributesToDeleteWithStrings(model.attributesToDelete);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformType platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return enableDefaultInternetAccess;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final List<AccessEndpoint.Builder> getAccessEndpoints() {
            List<AccessEndpoint.Builder> result = AccessEndpointListCopier.copyToBuilder(this.accessEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessEndpoints(Collection<AccessEndpoint.BuilderImpl> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copyFromBuilder(accessEndpoints);
        }

        @Override
        public final Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copy(accessEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(AccessEndpoint... accessEndpoints) {
            accessEndpoints(Arrays.asList(accessEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(Consumer<AccessEndpoint.Builder>... accessEndpoints) {
            accessEndpoints(Stream.of(accessEndpoints).map(c -> AccessEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAttributesToDelete() {
            if (attributesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return attributesToDelete;
        }

        public final void setAttributesToDelete(Collection<String> attributesToDelete) {
            this.attributesToDelete = AppBlockBuilderAttributesCopier.copy(attributesToDelete);
        }

        @Override
        public final Builder attributesToDeleteWithStrings(Collection<String> attributesToDelete) {
            this.attributesToDelete = AppBlockBuilderAttributesCopier.copy(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDeleteWithStrings(String... attributesToDelete) {
            attributesToDeleteWithStrings(Arrays.asList(attributesToDelete));
            return this;
        }

        @Override
        public final Builder attributesToDelete(Collection<AppBlockBuilderAttribute> attributesToDelete) {
            this.attributesToDelete = AppBlockBuilderAttributesCopier.copyEnumToString(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDelete(AppBlockBuilderAttribute... attributesToDelete) {
            attributesToDelete(Arrays.asList(attributesToDelete));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAppBlockBuilderRequest build() {
            return new UpdateAppBlockBuilderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
