/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AppVisibility {
    ALL("ALL"),
    ASSOCIATED("ASSOCIATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AppVisibility> VALUE_MAP;
    private final String value;

    private AppVisibility(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AppVisibility fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AppVisibility> knownValues() {
        EnumSet<AppVisibility> knownValues = EnumSet.allOf(AppVisibility.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AppVisibility.class, AppVisibility::toString);
    }
}

