/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the application fleet association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationFleetAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationFleetAssociation.Builder, ApplicationFleetAssociation> {
    private static final SdkField<String> FLEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetName").getter(getter(ApplicationFleetAssociation::fleetName)).setter(setter(Builder::fleetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetName").build()).build();

    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationArn").getter(getter(ApplicationFleetAssociation::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_NAME_FIELD,
            APPLICATION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fleetName;

    private final String applicationArn;

    private ApplicationFleetAssociation(BuilderImpl builder) {
        this.fleetName = builder.fleetName;
        this.applicationArn = builder.applicationArn;
    }

    /**
     * <p>
     * The name of the fleet associated with the application.
     * </p>
     * 
     * @return The name of the fleet associated with the application.
     */
    public final String fleetName() {
        return fleetName;
    }

    /**
     * <p>
     * The ARN of the application associated with the fleet.
     * </p>
     * 
     * @return The ARN of the application associated with the fleet.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationFleetAssociation)) {
            return false;
        }
        ApplicationFleetAssociation other = (ApplicationFleetAssociation) obj;
        return Objects.equals(fleetName(), other.fleetName()) && Objects.equals(applicationArn(), other.applicationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationFleetAssociation").add("FleetName", fleetName())
                .add("ApplicationArn", applicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetName":
            return Optional.ofNullable(clazz.cast(fleetName()));
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationFleetAssociation, T> g) {
        return obj -> g.apply((ApplicationFleetAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationFleetAssociation> {
        /**
         * <p>
         * The name of the fleet associated with the application.
         * </p>
         * 
         * @param fleetName
         *        The name of the fleet associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetName(String fleetName);

        /**
         * <p>
         * The ARN of the application associated with the fleet.
         * </p>
         * 
         * @param applicationArn
         *        The ARN of the application associated with the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);
    }

    static final class BuilderImpl implements Builder {
        private String fleetName;

        private String applicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationFleetAssociation model) {
            fleetName(model.fleetName);
            applicationArn(model.applicationArn);
        }

        public final String getFleetName() {
            return fleetName;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        @Override
        public ApplicationFleetAssociation build() {
            return new ApplicationFleetAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
