/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apprunner.AppRunnerClient;
import software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsRequest;
import software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsResponse;

public class DescribeCustomDomainsIterable
implements SdkIterable<DescribeCustomDomainsResponse> {
    private final AppRunnerClient client;
    private final DescribeCustomDomainsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCustomDomainsIterable(AppRunnerClient client, DescribeCustomDomainsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCustomDomainsResponseFetcher();
    }

    public Iterator<DescribeCustomDomainsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeCustomDomainsResponseFetcher
    implements SyncPageFetcher<DescribeCustomDomainsResponse> {
        private DescribeCustomDomainsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCustomDomainsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeCustomDomainsResponse nextPage(DescribeCustomDomainsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCustomDomainsIterable.this.client.describeCustomDomains(DescribeCustomDomainsIterable.this.firstRequest);
            }
            return DescribeCustomDomainsIterable.this.client.describeCustomDomains((DescribeCustomDomainsRequest)((Object)DescribeCustomDomainsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

