/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationStatus;
import software.amazon.awssdk.services.apprunner.model.TraceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ObservabilityConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ObservabilityConfiguration> {
    private static final SdkField<String> OBSERVABILITY_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObservabilityConfigurationArn").getter(ObservabilityConfiguration.getter(ObservabilityConfiguration::observabilityConfigurationArn)).setter(ObservabilityConfiguration.setter(Builder::observabilityConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityConfigurationArn").build()}).build();
    private static final SdkField<String> OBSERVABILITY_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObservabilityConfigurationName").getter(ObservabilityConfiguration.getter(ObservabilityConfiguration::observabilityConfigurationName)).setter(ObservabilityConfiguration.setter(Builder::observabilityConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityConfigurationName").build()}).build();
    private static final SdkField<TraceConfiguration> TRACE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TraceConfiguration").getter(ObservabilityConfiguration.getter(ObservabilityConfiguration::traceConfiguration)).setter(ObservabilityConfiguration.setter(Builder::traceConfiguration)).constructor(TraceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceConfiguration").build()}).build();
    private static final SdkField<Integer> OBSERVABILITY_CONFIGURATION_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ObservabilityConfigurationRevision").getter(ObservabilityConfiguration.getter(ObservabilityConfiguration::observabilityConfigurationRevision)).setter(ObservabilityConfiguration.setter(Builder::observabilityConfigurationRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityConfigurationRevision").build()}).build();
    private static final SdkField<Boolean> LATEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Latest").getter(ObservabilityConfiguration.getter(ObservabilityConfiguration::latest)).setter(ObservabilityConfiguration.setter(Builder::latest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Latest").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ObservabilityConfiguration.getter(ObservabilityConfiguration::statusAsString)).setter(ObservabilityConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(ObservabilityConfiguration.getter(ObservabilityConfiguration::createdAt)).setter(ObservabilityConfiguration.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> DELETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeletedAt").getter(ObservabilityConfiguration.getter(ObservabilityConfiguration::deletedAt)).setter(ObservabilityConfiguration.setter(Builder::deletedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBSERVABILITY_CONFIGURATION_ARN_FIELD, OBSERVABILITY_CONFIGURATION_NAME_FIELD, TRACE_CONFIGURATION_FIELD, OBSERVABILITY_CONFIGURATION_REVISION_FIELD, LATEST_FIELD, STATUS_FIELD, CREATED_AT_FIELD, DELETED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String observabilityConfigurationArn;
    private final String observabilityConfigurationName;
    private final TraceConfiguration traceConfiguration;
    private final Integer observabilityConfigurationRevision;
    private final Boolean latest;
    private final String status;
    private final Instant createdAt;
    private final Instant deletedAt;

    private ObservabilityConfiguration(BuilderImpl builder) {
        this.observabilityConfigurationArn = builder.observabilityConfigurationArn;
        this.observabilityConfigurationName = builder.observabilityConfigurationName;
        this.traceConfiguration = builder.traceConfiguration;
        this.observabilityConfigurationRevision = builder.observabilityConfigurationRevision;
        this.latest = builder.latest;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.deletedAt = builder.deletedAt;
    }

    public final String observabilityConfigurationArn() {
        return this.observabilityConfigurationArn;
    }

    public final String observabilityConfigurationName() {
        return this.observabilityConfigurationName;
    }

    public final TraceConfiguration traceConfiguration() {
        return this.traceConfiguration;
    }

    public final Integer observabilityConfigurationRevision() {
        return this.observabilityConfigurationRevision;
    }

    public final Boolean latest() {
        return this.latest;
    }

    public final ObservabilityConfigurationStatus status() {
        return ObservabilityConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant deletedAt() {
        return this.deletedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.observabilityConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.observabilityConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.observabilityConfigurationRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.latest());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObservabilityConfiguration)) {
            return false;
        }
        ObservabilityConfiguration other = (ObservabilityConfiguration)obj;
        return Objects.equals(this.observabilityConfigurationArn(), other.observabilityConfigurationArn()) && Objects.equals(this.observabilityConfigurationName(), other.observabilityConfigurationName()) && Objects.equals(this.traceConfiguration(), other.traceConfiguration()) && Objects.equals(this.observabilityConfigurationRevision(), other.observabilityConfigurationRevision()) && Objects.equals(this.latest(), other.latest()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.deletedAt(), other.deletedAt());
    }

    public final String toString() {
        return ToString.builder((String)"ObservabilityConfiguration").add("ObservabilityConfigurationArn", (Object)this.observabilityConfigurationArn()).add("ObservabilityConfigurationName", (Object)this.observabilityConfigurationName()).add("TraceConfiguration", (Object)this.traceConfiguration()).add("ObservabilityConfigurationRevision", (Object)this.observabilityConfigurationRevision()).add("Latest", (Object)this.latest()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("DeletedAt", (Object)this.deletedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObservabilityConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.observabilityConfigurationArn()));
            }
            case "ObservabilityConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.observabilityConfigurationName()));
            }
            case "TraceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.traceConfiguration()));
            }
            case "ObservabilityConfigurationRevision": {
                return Optional.ofNullable(clazz.cast(this.observabilityConfigurationRevision()));
            }
            case "Latest": {
                return Optional.ofNullable(clazz.cast(this.latest()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DeletedAt": {
                return Optional.ofNullable(clazz.cast(this.deletedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObservabilityConfiguration, T> g) {
        return obj -> g.apply((ObservabilityConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String observabilityConfigurationArn;
        private String observabilityConfigurationName;
        private TraceConfiguration traceConfiguration;
        private Integer observabilityConfigurationRevision;
        private Boolean latest;
        private String status;
        private Instant createdAt;
        private Instant deletedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ObservabilityConfiguration model) {
            this.observabilityConfigurationArn(model.observabilityConfigurationArn);
            this.observabilityConfigurationName(model.observabilityConfigurationName);
            this.traceConfiguration(model.traceConfiguration);
            this.observabilityConfigurationRevision(model.observabilityConfigurationRevision);
            this.latest(model.latest);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.deletedAt(model.deletedAt);
        }

        public final String getObservabilityConfigurationArn() {
            return this.observabilityConfigurationArn;
        }

        public final void setObservabilityConfigurationArn(String observabilityConfigurationArn) {
            this.observabilityConfigurationArn = observabilityConfigurationArn;
        }

        @Override
        public final Builder observabilityConfigurationArn(String observabilityConfigurationArn) {
            this.observabilityConfigurationArn = observabilityConfigurationArn;
            return this;
        }

        public final String getObservabilityConfigurationName() {
            return this.observabilityConfigurationName;
        }

        public final void setObservabilityConfigurationName(String observabilityConfigurationName) {
            this.observabilityConfigurationName = observabilityConfigurationName;
        }

        @Override
        public final Builder observabilityConfigurationName(String observabilityConfigurationName) {
            this.observabilityConfigurationName = observabilityConfigurationName;
            return this;
        }

        public final TraceConfiguration.Builder getTraceConfiguration() {
            return this.traceConfiguration != null ? this.traceConfiguration.toBuilder() : null;
        }

        public final void setTraceConfiguration(TraceConfiguration.BuilderImpl traceConfiguration) {
            this.traceConfiguration = traceConfiguration != null ? traceConfiguration.build() : null;
        }

        @Override
        public final Builder traceConfiguration(TraceConfiguration traceConfiguration) {
            this.traceConfiguration = traceConfiguration;
            return this;
        }

        public final Integer getObservabilityConfigurationRevision() {
            return this.observabilityConfigurationRevision;
        }

        public final void setObservabilityConfigurationRevision(Integer observabilityConfigurationRevision) {
            this.observabilityConfigurationRevision = observabilityConfigurationRevision;
        }

        @Override
        public final Builder observabilityConfigurationRevision(Integer observabilityConfigurationRevision) {
            this.observabilityConfigurationRevision = observabilityConfigurationRevision;
            return this;
        }

        public final Boolean getLatest() {
            return this.latest;
        }

        public final void setLatest(Boolean latest) {
            this.latest = latest;
        }

        @Override
        public final Builder latest(Boolean latest) {
            this.latest = latest;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ObservabilityConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getDeletedAt() {
            return this.deletedAt;
        }

        public final void setDeletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
        }

        @Override
        public final Builder deletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public ObservabilityConfiguration build() {
            return new ObservabilityConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ObservabilityConfiguration> {
        public Builder observabilityConfigurationArn(String var1);

        public Builder observabilityConfigurationName(String var1);

        public Builder traceConfiguration(TraceConfiguration var1);

        default public Builder traceConfiguration(Consumer<TraceConfiguration.Builder> traceConfiguration) {
            return this.traceConfiguration((TraceConfiguration)((TraceConfiguration.Builder)TraceConfiguration.builder().applyMutation(traceConfiguration)).build());
        }

        public Builder observabilityConfigurationRevision(Integer var1);

        public Builder latest(Boolean var1);

        public Builder status(String var1);

        public Builder status(ObservabilityConfigurationStatus var1);

        public Builder createdAt(Instant var1);

        public Builder deletedAt(Instant var1);
    }
}

