/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apprunner.model.CertificateValidationRecord;
import software.amazon.awssdk.services.apprunner.model.CertificateValidationRecordListCopier;
import software.amazon.awssdk.services.apprunner.model.CustomDomainAssociationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomDomain
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomDomain> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(CustomDomain.getter(CustomDomain::domainName)).setter(CustomDomain.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<Boolean> ENABLE_WWW_SUBDOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableWWWSubdomain").getter(CustomDomain.getter(CustomDomain::enableWWWSubdomain)).setter(CustomDomain.setter(Builder::enableWWWSubdomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableWWWSubdomain").build()}).build();
    private static final SdkField<List<CertificateValidationRecord>> CERTIFICATE_VALIDATION_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CertificateValidationRecords").getter(CustomDomain.getter(CustomDomain::certificateValidationRecords)).setter(CustomDomain.setter(Builder::certificateValidationRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateValidationRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CertificateValidationRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CustomDomain.getter(CustomDomain::statusAsString)).setter(CustomDomain.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ENABLE_WWW_SUBDOMAIN_FIELD, CERTIFICATE_VALIDATION_RECORDS_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final Boolean enableWWWSubdomain;
    private final List<CertificateValidationRecord> certificateValidationRecords;
    private final String status;

    private CustomDomain(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.enableWWWSubdomain = builder.enableWWWSubdomain;
        this.certificateValidationRecords = builder.certificateValidationRecords;
        this.status = builder.status;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final Boolean enableWWWSubdomain() {
        return this.enableWWWSubdomain;
    }

    public final boolean hasCertificateValidationRecords() {
        return this.certificateValidationRecords != null && !(this.certificateValidationRecords instanceof SdkAutoConstructList);
    }

    public final List<CertificateValidationRecord> certificateValidationRecords() {
        return this.certificateValidationRecords;
    }

    public final CustomDomainAssociationStatus status() {
        return CustomDomainAssociationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableWWWSubdomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificateValidationRecords() ? this.certificateValidationRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomDomain)) {
            return false;
        }
        CustomDomain other = (CustomDomain)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.enableWWWSubdomain(), other.enableWWWSubdomain()) && this.hasCertificateValidationRecords() == other.hasCertificateValidationRecords() && Objects.equals(this.certificateValidationRecords(), other.certificateValidationRecords()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CustomDomain").add("DomainName", (Object)this.domainName()).add("EnableWWWSubdomain", (Object)this.enableWWWSubdomain()).add("CertificateValidationRecords", this.hasCertificateValidationRecords() ? this.certificateValidationRecords() : null).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "EnableWWWSubdomain": {
                return Optional.ofNullable(clazz.cast(this.enableWWWSubdomain()));
            }
            case "CertificateValidationRecords": {
                return Optional.ofNullable(clazz.cast(this.certificateValidationRecords()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomDomain, T> g) {
        return obj -> g.apply((CustomDomain)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private Boolean enableWWWSubdomain;
        private List<CertificateValidationRecord> certificateValidationRecords = DefaultSdkAutoConstructList.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomDomain model) {
            this.domainName(model.domainName);
            this.enableWWWSubdomain(model.enableWWWSubdomain);
            this.certificateValidationRecords(model.certificateValidationRecords);
            this.status(model.status);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Boolean getEnableWWWSubdomain() {
            return this.enableWWWSubdomain;
        }

        public final void setEnableWWWSubdomain(Boolean enableWWWSubdomain) {
            this.enableWWWSubdomain = enableWWWSubdomain;
        }

        @Override
        public final Builder enableWWWSubdomain(Boolean enableWWWSubdomain) {
            this.enableWWWSubdomain = enableWWWSubdomain;
            return this;
        }

        public final List<CertificateValidationRecord.Builder> getCertificateValidationRecords() {
            List<CertificateValidationRecord.Builder> result = CertificateValidationRecordListCopier.copyToBuilder(this.certificateValidationRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificateValidationRecords(Collection<CertificateValidationRecord.BuilderImpl> certificateValidationRecords) {
            this.certificateValidationRecords = CertificateValidationRecordListCopier.copyFromBuilder(certificateValidationRecords);
        }

        @Override
        public final Builder certificateValidationRecords(Collection<CertificateValidationRecord> certificateValidationRecords) {
            this.certificateValidationRecords = CertificateValidationRecordListCopier.copy(certificateValidationRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateValidationRecords(CertificateValidationRecord ... certificateValidationRecords) {
            this.certificateValidationRecords(Arrays.asList(certificateValidationRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateValidationRecords(Consumer<CertificateValidationRecord.Builder> ... certificateValidationRecords) {
            this.certificateValidationRecords(Stream.of(certificateValidationRecords).map(c -> (CertificateValidationRecord)((CertificateValidationRecord.Builder)CertificateValidationRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CustomDomainAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public CustomDomain build() {
            return new CustomDomain(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomDomain> {
        public Builder domainName(String var1);

        public Builder enableWWWSubdomain(Boolean var1);

        public Builder certificateValidationRecords(Collection<CertificateValidationRecord> var1);

        public Builder certificateValidationRecords(CertificateValidationRecord ... var1);

        public Builder certificateValidationRecords(Consumer<CertificateValidationRecord.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(CustomDomainAssociationStatus var1);
    }
}

