/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a TCP route type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TcpRoute implements SdkPojo, Serializable, ToCopyableBuilder<TcpRoute.Builder, TcpRoute> {
    private static final SdkField<TcpRouteAction> ACTION_FIELD = SdkField.<TcpRouteAction> builder(MarshallingType.SDK_POJO)
            .memberName("action").getter(getter(TcpRoute::action)).setter(setter(Builder::action))
            .constructor(TcpRouteAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<TcpRouteMatch> MATCH_FIELD = SdkField.<TcpRouteMatch> builder(MarshallingType.SDK_POJO)
            .memberName("match").getter(getter(TcpRoute::match)).setter(setter(Builder::match))
            .constructor(TcpRouteMatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()).build();

    private static final SdkField<TcpTimeout> TIMEOUT_FIELD = SdkField.<TcpTimeout> builder(MarshallingType.SDK_POJO)
            .memberName("timeout").getter(getter(TcpRoute::timeout)).setter(setter(Builder::timeout))
            .constructor(TcpTimeout::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, MATCH_FIELD,
            TIMEOUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final TcpRouteAction action;

    private final TcpRouteMatch match;

    private final TcpTimeout timeout;

    private TcpRoute(BuilderImpl builder) {
        this.action = builder.action;
        this.match = builder.match;
        this.timeout = builder.timeout;
    }

    /**
     * <p>
     * The action to take if a match is determined.
     * </p>
     * 
     * @return The action to take if a match is determined.
     */
    public final TcpRouteAction action() {
        return action;
    }

    /**
     * <p>
     * An object that represents the criteria for determining a request match.
     * </p>
     * 
     * @return An object that represents the criteria for determining a request match.
     */
    public final TcpRouteMatch match() {
        return match;
    }

    /**
     * <p>
     * An object that represents types of timeouts.
     * </p>
     * 
     * @return An object that represents types of timeouts.
     */
    public final TcpTimeout timeout() {
        return timeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(match());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TcpRoute)) {
            return false;
        }
        TcpRoute other = (TcpRoute) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(match(), other.match())
                && Objects.equals(timeout(), other.timeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TcpRoute").add("Action", action()).add("Match", match()).add("Timeout", timeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "match":
            return Optional.ofNullable(clazz.cast(match()));
        case "timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TcpRoute, T> g) {
        return obj -> g.apply((TcpRoute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TcpRoute> {
        /**
         * <p>
         * The action to take if a match is determined.
         * </p>
         * 
         * @param action
         *        The action to take if a match is determined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(TcpRouteAction action);

        /**
         * <p>
         * The action to take if a match is determined.
         * </p>
         * This is a convenience method that creates an instance of the {@link TcpRouteAction.Builder} avoiding the need
         * to create one manually via {@link TcpRouteAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TcpRouteAction.Builder#build()} is called immediately and its
         * result is passed to {@link #action(TcpRouteAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link TcpRouteAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(TcpRouteAction)
         */
        default Builder action(Consumer<TcpRouteAction.Builder> action) {
            return action(TcpRouteAction.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * An object that represents the criteria for determining a request match.
         * </p>
         * 
         * @param match
         *        An object that represents the criteria for determining a request match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder match(TcpRouteMatch match);

        /**
         * <p>
         * An object that represents the criteria for determining a request match.
         * </p>
         * This is a convenience method that creates an instance of the {@link TcpRouteMatch.Builder} avoiding the need
         * to create one manually via {@link TcpRouteMatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TcpRouteMatch.Builder#build()} is called immediately and its
         * result is passed to {@link #match(TcpRouteMatch)}.
         * 
         * @param match
         *        a consumer that will call methods on {@link TcpRouteMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #match(TcpRouteMatch)
         */
        default Builder match(Consumer<TcpRouteMatch.Builder> match) {
            return match(TcpRouteMatch.builder().applyMutation(match).build());
        }

        /**
         * <p>
         * An object that represents types of timeouts.
         * </p>
         * 
         * @param timeout
         *        An object that represents types of timeouts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(TcpTimeout timeout);

        /**
         * <p>
         * An object that represents types of timeouts.
         * </p>
         * This is a convenience method that creates an instance of the {@link TcpTimeout.Builder} avoiding the need to
         * create one manually via {@link TcpTimeout#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TcpTimeout.Builder#build()} is called immediately and its result
         * is passed to {@link #timeout(TcpTimeout)}.
         * 
         * @param timeout
         *        a consumer that will call methods on {@link TcpTimeout.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeout(TcpTimeout)
         */
        default Builder timeout(Consumer<TcpTimeout.Builder> timeout) {
            return timeout(TcpTimeout.builder().applyMutation(timeout).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TcpRouteAction action;

        private TcpRouteMatch match;

        private TcpTimeout timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(TcpRoute model) {
            action(model.action);
            match(model.match);
            timeout(model.timeout);
        }

        public final TcpRouteAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(TcpRouteAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(TcpRouteAction action) {
            this.action = action;
            return this;
        }

        public final TcpRouteMatch.Builder getMatch() {
            return match != null ? match.toBuilder() : null;
        }

        public final void setMatch(TcpRouteMatch.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        @Override
        public final Builder match(TcpRouteMatch match) {
            this.match = match;
            return this;
        }

        public final TcpTimeout.Builder getTimeout() {
            return timeout != null ? timeout.toBuilder() : null;
        }

        public final void setTimeout(TcpTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        @Override
        public final Builder timeout(TcpTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        @Override
        public TcpRoute build() {
            return new TcpRoute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
