/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the default properties for a backend.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackendDefaults implements SdkPojo, Serializable, ToCopyableBuilder<BackendDefaults.Builder, BackendDefaults> {
    private static final SdkField<ClientPolicy> CLIENT_POLICY_FIELD = SdkField.<ClientPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("clientPolicy").getter(getter(BackendDefaults::clientPolicy)).setter(setter(Builder::clientPolicy))
            .constructor(ClientPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final ClientPolicy clientPolicy;

    private BackendDefaults(BuilderImpl builder) {
        this.clientPolicy = builder.clientPolicy;
    }

    /**
     * <p>
     * A reference to an object that represents a client policy.
     * </p>
     * 
     * @return A reference to an object that represents a client policy.
     */
    public final ClientPolicy clientPolicy() {
        return clientPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackendDefaults)) {
            return false;
        }
        BackendDefaults other = (BackendDefaults) obj;
        return Objects.equals(clientPolicy(), other.clientPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BackendDefaults").add("ClientPolicy", clientPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientPolicy":
            return Optional.ofNullable(clazz.cast(clientPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackendDefaults, T> g) {
        return obj -> g.apply((BackendDefaults) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackendDefaults> {
        /**
         * <p>
         * A reference to an object that represents a client policy.
         * </p>
         * 
         * @param clientPolicy
         *        A reference to an object that represents a client policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientPolicy(ClientPolicy clientPolicy);

        /**
         * <p>
         * A reference to an object that represents a client policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientPolicy.Builder} avoiding the need
         * to create one manually via {@link ClientPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #clientPolicy(ClientPolicy)}.
         * 
         * @param clientPolicy
         *        a consumer that will call methods on {@link ClientPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientPolicy(ClientPolicy)
         */
        default Builder clientPolicy(Consumer<ClientPolicy.Builder> clientPolicy) {
            return clientPolicy(ClientPolicy.builder().applyMutation(clientPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ClientPolicy clientPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(BackendDefaults model) {
            clientPolicy(model.clientPolicy);
        }

        public final ClientPolicy.Builder getClientPolicy() {
            return clientPolicy != null ? clientPolicy.toBuilder() : null;
        }

        public final void setClientPolicy(ClientPolicy.BuilderImpl clientPolicy) {
            this.clientPolicy = clientPolicy != null ? clientPolicy.build() : null;
        }

        @Override
        public final Builder clientPolicy(ClientPolicy clientPolicy) {
            this.clientPolicy = clientPolicy;
            return this;
        }

        @Override
        public BackendDefaults build() {
            return new BackendDefaults(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
