/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appmesh.AppMeshClient;
import software.amazon.awssdk.services.appmesh.internal.UserAgentUtils;
import software.amazon.awssdk.services.appmesh.model.ListVirtualServicesRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualServicesResponse;
import software.amazon.awssdk.services.appmesh.model.VirtualServiceRef;

public class ListVirtualServicesIterable
implements SdkIterable<ListVirtualServicesResponse> {
    private final AppMeshClient client;
    private final ListVirtualServicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVirtualServicesIterable(AppMeshClient client, ListVirtualServicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVirtualServicesResponseFetcher();
    }

    public Iterator<ListVirtualServicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VirtualServiceRef> virtualServices() {
        Function<ListVirtualServicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.virtualServices() != null) {
                return response.virtualServices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVirtualServicesResponseFetcher
    implements SyncPageFetcher<ListVirtualServicesResponse> {
        private ListVirtualServicesResponseFetcher() {
        }

        public boolean hasNextPage(ListVirtualServicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVirtualServicesResponse nextPage(ListVirtualServicesResponse previousPage) {
            if (previousPage == null) {
                return ListVirtualServicesIterable.this.client.listVirtualServices(ListVirtualServicesIterable.this.firstRequest);
            }
            return ListVirtualServicesIterable.this.client.listVirtualServices((ListVirtualServicesRequest)((Object)ListVirtualServicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

