/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingClient;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingClientBuilder;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingServiceClientConfiguration;
import software.amazon.awssdk.services.applicationautoscaling.DefaultApplicationAutoScalingBaseClientBuilder;
import software.amazon.awssdk.services.applicationautoscaling.DefaultApplicationAutoScalingClient;
import software.amazon.awssdk.services.applicationautoscaling.endpoints.ApplicationAutoScalingEndpointProvider;

@SdkInternalApi
final class DefaultApplicationAutoScalingClientBuilder
extends DefaultApplicationAutoScalingBaseClientBuilder<ApplicationAutoScalingClientBuilder, ApplicationAutoScalingClient>
implements ApplicationAutoScalingClientBuilder {
    DefaultApplicationAutoScalingClientBuilder() {
    }

    @Override
    public DefaultApplicationAutoScalingClientBuilder endpointProvider(ApplicationAutoScalingEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ApplicationAutoScalingClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultApplicationAutoScalingClientBuilder.validateClientOptions(clientConfiguration);
        ApplicationAutoScalingServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultApplicationAutoScalingClient client = new DefaultApplicationAutoScalingClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ApplicationAutoScalingServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ApplicationAutoScalingServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

