/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.appintegrations.AppIntegrationsClient;
import software.amazon.awssdk.services.appintegrations.AppIntegrationsClientBuilder;
import software.amazon.awssdk.services.appintegrations.AppIntegrationsServiceClientConfiguration;
import software.amazon.awssdk.services.appintegrations.DefaultAppIntegrationsBaseClientBuilder;
import software.amazon.awssdk.services.appintegrations.DefaultAppIntegrationsClient;
import software.amazon.awssdk.services.appintegrations.endpoints.AppIntegrationsEndpointProvider;

@SdkInternalApi
final class DefaultAppIntegrationsClientBuilder
extends DefaultAppIntegrationsBaseClientBuilder<AppIntegrationsClientBuilder, AppIntegrationsClient>
implements AppIntegrationsClientBuilder {
    DefaultAppIntegrationsClientBuilder() {
    }

    @Override
    public DefaultAppIntegrationsClientBuilder endpointProvider(AppIntegrationsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AppIntegrationsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAppIntegrationsClientBuilder.validateClientOptions(clientConfiguration);
        AppIntegrationsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAppIntegrationsClient client = new DefaultAppIntegrationsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AppIntegrationsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AppIntegrationsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

