/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific profile properties required when using SAPOData.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SAPODataConnectorProfileProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<SAPODataConnectorProfileProperties.Builder, SAPODataConnectorProfileProperties> {
    private static final SdkField<String> APPLICATION_HOST_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationHostUrl").getter(getter(SAPODataConnectorProfileProperties::applicationHostUrl))
            .setter(setter(Builder::applicationHostUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationHostUrl").build())
            .build();

    private static final SdkField<String> APPLICATION_SERVICE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationServicePath").getter(getter(SAPODataConnectorProfileProperties::applicationServicePath))
            .setter(setter(Builder::applicationServicePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationServicePath").build())
            .build();

    private static final SdkField<Integer> PORT_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("portNumber").getter(getter(SAPODataConnectorProfileProperties::portNumber))
            .setter(setter(Builder::portNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portNumber").build()).build();

    private static final SdkField<String> CLIENT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientNumber").getter(getter(SAPODataConnectorProfileProperties::clientNumber))
            .setter(setter(Builder::clientNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientNumber").build()).build();

    private static final SdkField<String> LOGON_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logonLanguage").getter(getter(SAPODataConnectorProfileProperties::logonLanguage))
            .setter(setter(Builder::logonLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logonLanguage").build()).build();

    private static final SdkField<String> PRIVATE_LINK_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("privateLinkServiceName").getter(getter(SAPODataConnectorProfileProperties::privateLinkServiceName))
            .setter(setter(Builder::privateLinkServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateLinkServiceName").build())
            .build();

    private static final SdkField<OAuthProperties> O_AUTH_PROPERTIES_FIELD = SdkField
            .<OAuthProperties> builder(MarshallingType.SDK_POJO).memberName("oAuthProperties")
            .getter(getter(SAPODataConnectorProfileProperties::oAuthProperties)).setter(setter(Builder::oAuthProperties))
            .constructor(OAuthProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthProperties").build()).build();

    private static final SdkField<Boolean> DISABLE_SSO_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("disableSSO").getter(getter(SAPODataConnectorProfileProperties::disableSSO))
            .setter(setter(Builder::disableSSO))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableSSO").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_HOST_URL_FIELD,
            APPLICATION_SERVICE_PATH_FIELD, PORT_NUMBER_FIELD, CLIENT_NUMBER_FIELD, LOGON_LANGUAGE_FIELD,
            PRIVATE_LINK_SERVICE_NAME_FIELD, O_AUTH_PROPERTIES_FIELD, DISABLE_SSO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationHostUrl;

    private final String applicationServicePath;

    private final Integer portNumber;

    private final String clientNumber;

    private final String logonLanguage;

    private final String privateLinkServiceName;

    private final OAuthProperties oAuthProperties;

    private final Boolean disableSSO;

    private SAPODataConnectorProfileProperties(BuilderImpl builder) {
        this.applicationHostUrl = builder.applicationHostUrl;
        this.applicationServicePath = builder.applicationServicePath;
        this.portNumber = builder.portNumber;
        this.clientNumber = builder.clientNumber;
        this.logonLanguage = builder.logonLanguage;
        this.privateLinkServiceName = builder.privateLinkServiceName;
        this.oAuthProperties = builder.oAuthProperties;
        this.disableSSO = builder.disableSSO;
    }

    /**
     * <p>
     * The location of the SAPOData resource.
     * </p>
     * 
     * @return The location of the SAPOData resource.
     */
    public final String applicationHostUrl() {
        return applicationHostUrl;
    }

    /**
     * <p>
     * The application path to catalog service.
     * </p>
     * 
     * @return The application path to catalog service.
     */
    public final String applicationServicePath() {
        return applicationServicePath;
    }

    /**
     * <p>
     * The port number of the SAPOData instance.
     * </p>
     * 
     * @return The port number of the SAPOData instance.
     */
    public final Integer portNumber() {
        return portNumber;
    }

    /**
     * <p>
     * The client number for the client creating the connection.
     * </p>
     * 
     * @return The client number for the client creating the connection.
     */
    public final String clientNumber() {
        return clientNumber;
    }

    /**
     * <p>
     * The logon language of SAPOData instance.
     * </p>
     * 
     * @return The logon language of SAPOData instance.
     */
    public final String logonLanguage() {
        return logonLanguage;
    }

    /**
     * <p>
     * The SAPOData Private Link service name to be used for private data transfers.
     * </p>
     * 
     * @return The SAPOData Private Link service name to be used for private data transfers.
     */
    public final String privateLinkServiceName() {
        return privateLinkServiceName;
    }

    /**
     * <p>
     * The SAPOData OAuth properties required for OAuth type authentication.
     * </p>
     * 
     * @return The SAPOData OAuth properties required for OAuth type authentication.
     */
    public final OAuthProperties oAuthProperties() {
        return oAuthProperties;
    }

    /**
     * <p>
     * If you set this parameter to <code>true</code>, Amazon AppFlow bypasses the single sign-on (SSO) settings in your
     * SAP account when it accesses your SAP OData instance.
     * </p>
     * <p>
     * Whether you need this option depends on the types of credentials that you applied to your SAP OData connection
     * profile. If your profile uses basic authentication credentials, SAP SSO can prevent Amazon AppFlow from
     * connecting to your account with your username and password. In this case, bypassing SSO makes it possible for
     * Amazon AppFlow to connect successfully. However, if your profile uses OAuth credentials, this parameter has no
     * affect.
     * </p>
     * 
     * @return If you set this parameter to <code>true</code>, Amazon AppFlow bypasses the single sign-on (SSO) settings
     *         in your SAP account when it accesses your SAP OData instance.</p>
     *         <p>
     *         Whether you need this option depends on the types of credentials that you applied to your SAP OData
     *         connection profile. If your profile uses basic authentication credentials, SAP SSO can prevent Amazon
     *         AppFlow from connecting to your account with your username and password. In this case, bypassing SSO
     *         makes it possible for Amazon AppFlow to connect successfully. However, if your profile uses OAuth
     *         credentials, this parameter has no affect.
     */
    public final Boolean disableSSO() {
        return disableSSO;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationHostUrl());
        hashCode = 31 * hashCode + Objects.hashCode(applicationServicePath());
        hashCode = 31 * hashCode + Objects.hashCode(portNumber());
        hashCode = 31 * hashCode + Objects.hashCode(clientNumber());
        hashCode = 31 * hashCode + Objects.hashCode(logonLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(privateLinkServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(oAuthProperties());
        hashCode = 31 * hashCode + Objects.hashCode(disableSSO());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAPODataConnectorProfileProperties)) {
            return false;
        }
        SAPODataConnectorProfileProperties other = (SAPODataConnectorProfileProperties) obj;
        return Objects.equals(applicationHostUrl(), other.applicationHostUrl())
                && Objects.equals(applicationServicePath(), other.applicationServicePath())
                && Objects.equals(portNumber(), other.portNumber()) && Objects.equals(clientNumber(), other.clientNumber())
                && Objects.equals(logonLanguage(), other.logonLanguage())
                && Objects.equals(privateLinkServiceName(), other.privateLinkServiceName())
                && Objects.equals(oAuthProperties(), other.oAuthProperties()) && Objects.equals(disableSSO(), other.disableSSO());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SAPODataConnectorProfileProperties").add("ApplicationHostUrl", applicationHostUrl())
                .add("ApplicationServicePath", applicationServicePath()).add("PortNumber", portNumber())
                .add("ClientNumber", clientNumber()).add("LogonLanguage", logonLanguage())
                .add("PrivateLinkServiceName", privateLinkServiceName()).add("OAuthProperties", oAuthProperties())
                .add("DisableSSO", disableSSO()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationHostUrl":
            return Optional.ofNullable(clazz.cast(applicationHostUrl()));
        case "applicationServicePath":
            return Optional.ofNullable(clazz.cast(applicationServicePath()));
        case "portNumber":
            return Optional.ofNullable(clazz.cast(portNumber()));
        case "clientNumber":
            return Optional.ofNullable(clazz.cast(clientNumber()));
        case "logonLanguage":
            return Optional.ofNullable(clazz.cast(logonLanguage()));
        case "privateLinkServiceName":
            return Optional.ofNullable(clazz.cast(privateLinkServiceName()));
        case "oAuthProperties":
            return Optional.ofNullable(clazz.cast(oAuthProperties()));
        case "disableSSO":
            return Optional.ofNullable(clazz.cast(disableSSO()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SAPODataConnectorProfileProperties, T> g) {
        return obj -> g.apply((SAPODataConnectorProfileProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SAPODataConnectorProfileProperties> {
        /**
         * <p>
         * The location of the SAPOData resource.
         * </p>
         * 
         * @param applicationHostUrl
         *        The location of the SAPOData resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationHostUrl(String applicationHostUrl);

        /**
         * <p>
         * The application path to catalog service.
         * </p>
         * 
         * @param applicationServicePath
         *        The application path to catalog service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationServicePath(String applicationServicePath);

        /**
         * <p>
         * The port number of the SAPOData instance.
         * </p>
         * 
         * @param portNumber
         *        The port number of the SAPOData instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portNumber(Integer portNumber);

        /**
         * <p>
         * The client number for the client creating the connection.
         * </p>
         * 
         * @param clientNumber
         *        The client number for the client creating the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientNumber(String clientNumber);

        /**
         * <p>
         * The logon language of SAPOData instance.
         * </p>
         * 
         * @param logonLanguage
         *        The logon language of SAPOData instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logonLanguage(String logonLanguage);

        /**
         * <p>
         * The SAPOData Private Link service name to be used for private data transfers.
         * </p>
         * 
         * @param privateLinkServiceName
         *        The SAPOData Private Link service name to be used for private data transfers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateLinkServiceName(String privateLinkServiceName);

        /**
         * <p>
         * The SAPOData OAuth properties required for OAuth type authentication.
         * </p>
         * 
         * @param oAuthProperties
         *        The SAPOData OAuth properties required for OAuth type authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthProperties(OAuthProperties oAuthProperties);

        /**
         * <p>
         * The SAPOData OAuth properties required for OAuth type authentication.
         * </p>
         * This is a convenience method that creates an instance of the {@link OAuthProperties.Builder} avoiding the
         * need to create one manually via {@link OAuthProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OAuthProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #oAuthProperties(OAuthProperties)}.
         * 
         * @param oAuthProperties
         *        a consumer that will call methods on {@link OAuthProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuthProperties(OAuthProperties)
         */
        default Builder oAuthProperties(Consumer<OAuthProperties.Builder> oAuthProperties) {
            return oAuthProperties(OAuthProperties.builder().applyMutation(oAuthProperties).build());
        }

        /**
         * <p>
         * If you set this parameter to <code>true</code>, Amazon AppFlow bypasses the single sign-on (SSO) settings in
         * your SAP account when it accesses your SAP OData instance.
         * </p>
         * <p>
         * Whether you need this option depends on the types of credentials that you applied to your SAP OData
         * connection profile. If your profile uses basic authentication credentials, SAP SSO can prevent Amazon AppFlow
         * from connecting to your account with your username and password. In this case, bypassing SSO makes it
         * possible for Amazon AppFlow to connect successfully. However, if your profile uses OAuth credentials, this
         * parameter has no affect.
         * </p>
         * 
         * @param disableSSO
         *        If you set this parameter to <code>true</code>, Amazon AppFlow bypasses the single sign-on (SSO)
         *        settings in your SAP account when it accesses your SAP OData instance.</p>
         *        <p>
         *        Whether you need this option depends on the types of credentials that you applied to your SAP OData
         *        connection profile. If your profile uses basic authentication credentials, SAP SSO can prevent Amazon
         *        AppFlow from connecting to your account with your username and password. In this case, bypassing SSO
         *        makes it possible for Amazon AppFlow to connect successfully. However, if your profile uses OAuth
         *        credentials, this parameter has no affect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableSSO(Boolean disableSSO);
    }

    static final class BuilderImpl implements Builder {
        private String applicationHostUrl;

        private String applicationServicePath;

        private Integer portNumber;

        private String clientNumber;

        private String logonLanguage;

        private String privateLinkServiceName;

        private OAuthProperties oAuthProperties;

        private Boolean disableSSO;

        private BuilderImpl() {
        }

        private BuilderImpl(SAPODataConnectorProfileProperties model) {
            applicationHostUrl(model.applicationHostUrl);
            applicationServicePath(model.applicationServicePath);
            portNumber(model.portNumber);
            clientNumber(model.clientNumber);
            logonLanguage(model.logonLanguage);
            privateLinkServiceName(model.privateLinkServiceName);
            oAuthProperties(model.oAuthProperties);
            disableSSO(model.disableSSO);
        }

        public final String getApplicationHostUrl() {
            return applicationHostUrl;
        }

        public final void setApplicationHostUrl(String applicationHostUrl) {
            this.applicationHostUrl = applicationHostUrl;
        }

        @Override
        public final Builder applicationHostUrl(String applicationHostUrl) {
            this.applicationHostUrl = applicationHostUrl;
            return this;
        }

        public final String getApplicationServicePath() {
            return applicationServicePath;
        }

        public final void setApplicationServicePath(String applicationServicePath) {
            this.applicationServicePath = applicationServicePath;
        }

        @Override
        public final Builder applicationServicePath(String applicationServicePath) {
            this.applicationServicePath = applicationServicePath;
            return this;
        }

        public final Integer getPortNumber() {
            return portNumber;
        }

        public final void setPortNumber(Integer portNumber) {
            this.portNumber = portNumber;
        }

        @Override
        public final Builder portNumber(Integer portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public final String getClientNumber() {
            return clientNumber;
        }

        public final void setClientNumber(String clientNumber) {
            this.clientNumber = clientNumber;
        }

        @Override
        public final Builder clientNumber(String clientNumber) {
            this.clientNumber = clientNumber;
            return this;
        }

        public final String getLogonLanguage() {
            return logonLanguage;
        }

        public final void setLogonLanguage(String logonLanguage) {
            this.logonLanguage = logonLanguage;
        }

        @Override
        public final Builder logonLanguage(String logonLanguage) {
            this.logonLanguage = logonLanguage;
            return this;
        }

        public final String getPrivateLinkServiceName() {
            return privateLinkServiceName;
        }

        public final void setPrivateLinkServiceName(String privateLinkServiceName) {
            this.privateLinkServiceName = privateLinkServiceName;
        }

        @Override
        public final Builder privateLinkServiceName(String privateLinkServiceName) {
            this.privateLinkServiceName = privateLinkServiceName;
            return this;
        }

        public final OAuthProperties.Builder getOAuthProperties() {
            return oAuthProperties != null ? oAuthProperties.toBuilder() : null;
        }

        public final void setOAuthProperties(OAuthProperties.BuilderImpl oAuthProperties) {
            this.oAuthProperties = oAuthProperties != null ? oAuthProperties.build() : null;
        }

        @Override
        public final Builder oAuthProperties(OAuthProperties oAuthProperties) {
            this.oAuthProperties = oAuthProperties;
            return this;
        }

        public final Boolean getDisableSSO() {
            return disableSSO;
        }

        public final void setDisableSSO(Boolean disableSSO) {
            this.disableSSO = disableSSO;
        }

        @Override
        public final Builder disableSSO(Boolean disableSSO) {
            this.disableSSO = disableSSO;
            return this;
        }

        @Override
        public SAPODataConnectorProfileProperties build() {
            return new SAPODataConnectorProfileProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
