/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartFlowResponse extends AppflowResponse implements
        ToCopyableBuilder<StartFlowResponse.Builder, StartFlowResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowArn").getter(getter(StartFlowResponse::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<String> FLOW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowStatus").getter(getter(StartFlowResponse::flowStatusAsString)).setter(setter(Builder::flowStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowStatus").build()).build();

    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(StartFlowResponse::executionId)).setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD,
            FLOW_STATUS_FIELD, EXECUTION_ID_FIELD));

    private final String flowArn;

    private final String flowStatus;

    private final String executionId;

    private StartFlowResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.flowStatus = builder.flowStatus;
        this.executionId = builder.executionId;
    }

    /**
     * <p>
     * The flow's Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The flow's Amazon Resource Name (ARN).
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * <p>
     * Indicates the current status of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flowStatus} will
     * return {@link FlowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flowStatusAsString}.
     * </p>
     * 
     * @return Indicates the current status of the flow.
     * @see FlowStatus
     */
    public final FlowStatus flowStatus() {
        return FlowStatus.fromValue(flowStatus);
    }

    /**
     * <p>
     * Indicates the current status of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flowStatus} will
     * return {@link FlowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flowStatusAsString}.
     * </p>
     * 
     * @return Indicates the current status of the flow.
     * @see FlowStatus
     */
    public final String flowStatusAsString() {
        return flowStatus;
    }

    /**
     * <p>
     * Returns the internal execution ID of an on-demand flow when the flow is started. For scheduled or event-triggered
     * flows, this value is null.
     * </p>
     * 
     * @return Returns the internal execution ID of an on-demand flow when the flow is started. For scheduled or
     *         event-triggered flows, this value is null.
     */
    public final String executionId() {
        return executionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFlowResponse)) {
            return false;
        }
        StartFlowResponse other = (StartFlowResponse) obj;
        return Objects.equals(flowArn(), other.flowArn()) && Objects.equals(flowStatusAsString(), other.flowStatusAsString())
                && Objects.equals(executionId(), other.executionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartFlowResponse").add("FlowArn", flowArn()).add("FlowStatus", flowStatusAsString())
                .add("ExecutionId", executionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "flowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "flowStatus":
            return Optional.ofNullable(clazz.cast(flowStatusAsString()));
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartFlowResponse, T> g) {
        return obj -> g.apply((StartFlowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartFlowResponse> {
        /**
         * <p>
         * The flow's Amazon Resource Name (ARN).
         * </p>
         * 
         * @param flowArn
         *        The flow's Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * <p>
         * Indicates the current status of the flow.
         * </p>
         * 
         * @param flowStatus
         *        Indicates the current status of the flow.
         * @see FlowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowStatus
         */
        Builder flowStatus(String flowStatus);

        /**
         * <p>
         * Indicates the current status of the flow.
         * </p>
         * 
         * @param flowStatus
         *        Indicates the current status of the flow.
         * @see FlowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowStatus
         */
        Builder flowStatus(FlowStatus flowStatus);

        /**
         * <p>
         * Returns the internal execution ID of an on-demand flow when the flow is started. For scheduled or
         * event-triggered flows, this value is null.
         * </p>
         * 
         * @param executionId
         *        Returns the internal execution ID of an on-demand flow when the flow is started. For scheduled or
         *        event-triggered flows, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);
    }

    static final class BuilderImpl extends AppflowResponse.BuilderImpl implements Builder {
        private String flowArn;

        private String flowStatus;

        private String executionId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartFlowResponse model) {
            super(model);
            flowArn(model.flowArn);
            flowStatus(model.flowStatus);
            executionId(model.executionId);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getFlowStatus() {
            return flowStatus;
        }

        public final void setFlowStatus(String flowStatus) {
            this.flowStatus = flowStatus;
        }

        @Override
        public final Builder flowStatus(String flowStatus) {
            this.flowStatus = flowStatus;
            return this;
        }

        @Override
        public final Builder flowStatus(FlowStatus flowStatus) {
            this.flowStatus(flowStatus == null ? null : flowStatus.toString());
            return this;
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        @Override
        public StartFlowResponse build() {
            return new StartFlowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
