/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appfabric.model.ResultStatus;
import software.amazon.awssdk.services.appfabric.model.TaskError;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserAccessResultItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserAccessResultItem> {
    private static final SdkField<String> APP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("app").getter(UserAccessResultItem.getter(UserAccessResultItem::app)).setter(UserAccessResultItem.setter(Builder::app)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("app").build()}).build();
    private static final SdkField<String> TENANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tenantId").getter(UserAccessResultItem.getter(UserAccessResultItem::tenantId)).setter(UserAccessResultItem.setter(Builder::tenantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenantId").build()}).build();
    private static final SdkField<String> TENANT_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tenantDisplayName").getter(UserAccessResultItem.getter(UserAccessResultItem::tenantDisplayName)).setter(UserAccessResultItem.setter(Builder::tenantDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenantDisplayName").build()}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(UserAccessResultItem.getter(UserAccessResultItem::taskId)).setter(UserAccessResultItem.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<String> RESULT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resultStatus").getter(UserAccessResultItem.getter(UserAccessResultItem::resultStatusAsString)).setter(UserAccessResultItem.setter(Builder::resultStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultStatus").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("email").getter(UserAccessResultItem.getter(UserAccessResultItem::email)).setter(UserAccessResultItem.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(UserAccessResultItem.getter(UserAccessResultItem::userId)).setter(UserAccessResultItem.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> USER_FULL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userFullName").getter(UserAccessResultItem.getter(UserAccessResultItem::userFullName)).setter(UserAccessResultItem.setter(Builder::userFullName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userFullName").build()}).build();
    private static final SdkField<String> USER_FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userFirstName").getter(UserAccessResultItem.getter(UserAccessResultItem::userFirstName)).setter(UserAccessResultItem.setter(Builder::userFirstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userFirstName").build()}).build();
    private static final SdkField<String> USER_LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userLastName").getter(UserAccessResultItem.getter(UserAccessResultItem::userLastName)).setter(UserAccessResultItem.setter(Builder::userLastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userLastName").build()}).build();
    private static final SdkField<String> USER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userStatus").getter(UserAccessResultItem.getter(UserAccessResultItem::userStatus)).setter(UserAccessResultItem.setter(Builder::userStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userStatus").build()}).build();
    private static final SdkField<TaskError> TASK_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("taskError").getter(UserAccessResultItem.getter(UserAccessResultItem::taskError)).setter(UserAccessResultItem.setter(Builder::taskError)).constructor(TaskError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskError").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_FIELD, TENANT_ID_FIELD, TENANT_DISPLAY_NAME_FIELD, TASK_ID_FIELD, RESULT_STATUS_FIELD, EMAIL_FIELD, USER_ID_FIELD, USER_FULL_NAME_FIELD, USER_FIRST_NAME_FIELD, USER_LAST_NAME_FIELD, USER_STATUS_FIELD, TASK_ERROR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String app;
    private final String tenantId;
    private final String tenantDisplayName;
    private final String taskId;
    private final String resultStatus;
    private final String email;
    private final String userId;
    private final String userFullName;
    private final String userFirstName;
    private final String userLastName;
    private final String userStatus;
    private final TaskError taskError;

    private UserAccessResultItem(BuilderImpl builder) {
        this.app = builder.app;
        this.tenantId = builder.tenantId;
        this.tenantDisplayName = builder.tenantDisplayName;
        this.taskId = builder.taskId;
        this.resultStatus = builder.resultStatus;
        this.email = builder.email;
        this.userId = builder.userId;
        this.userFullName = builder.userFullName;
        this.userFirstName = builder.userFirstName;
        this.userLastName = builder.userLastName;
        this.userStatus = builder.userStatus;
        this.taskError = builder.taskError;
    }

    public final String app() {
        return this.app;
    }

    public final String tenantId() {
        return this.tenantId;
    }

    public final String tenantDisplayName() {
        return this.tenantDisplayName;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final ResultStatus resultStatus() {
        return ResultStatus.fromValue(this.resultStatus);
    }

    public final String resultStatusAsString() {
        return this.resultStatus;
    }

    public final String email() {
        return this.email;
    }

    public final String userId() {
        return this.userId;
    }

    public final String userFullName() {
        return this.userFullName;
    }

    public final String userFirstName() {
        return this.userFirstName;
    }

    public final String userLastName() {
        return this.userLastName;
    }

    public final String userStatus() {
        return this.userStatus;
    }

    public final TaskError taskError() {
        return this.taskError;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.app());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userFullName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userFirstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userLastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskError());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserAccessResultItem)) {
            return false;
        }
        UserAccessResultItem other = (UserAccessResultItem)obj;
        return Objects.equals(this.app(), other.app()) && Objects.equals(this.tenantId(), other.tenantId()) && Objects.equals(this.tenantDisplayName(), other.tenantDisplayName()) && Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.resultStatusAsString(), other.resultStatusAsString()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.userFullName(), other.userFullName()) && Objects.equals(this.userFirstName(), other.userFirstName()) && Objects.equals(this.userLastName(), other.userLastName()) && Objects.equals(this.userStatus(), other.userStatus()) && Objects.equals(this.taskError(), other.taskError());
    }

    public final String toString() {
        return ToString.builder((String)"UserAccessResultItem").add("App", (Object)this.app()).add("TenantId", (Object)this.tenantId()).add("TenantDisplayName", (Object)this.tenantDisplayName()).add("TaskId", (Object)this.taskId()).add("ResultStatus", (Object)this.resultStatusAsString()).add("Email", (Object)(this.email() == null ? null : "*** Sensitive Data Redacted ***")).add("UserId", (Object)(this.userId() == null ? null : "*** Sensitive Data Redacted ***")).add("UserFullName", (Object)(this.userFullName() == null ? null : "*** Sensitive Data Redacted ***")).add("UserFirstName", (Object)(this.userFirstName() == null ? null : "*** Sensitive Data Redacted ***")).add("UserLastName", (Object)(this.userLastName() == null ? null : "*** Sensitive Data Redacted ***")).add("UserStatus", (Object)this.userStatus()).add("TaskError", (Object)this.taskError()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "app": {
                return Optional.ofNullable(clazz.cast(this.app()));
            }
            case "tenantId": {
                return Optional.ofNullable(clazz.cast(this.tenantId()));
            }
            case "tenantDisplayName": {
                return Optional.ofNullable(clazz.cast(this.tenantDisplayName()));
            }
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "resultStatus": {
                return Optional.ofNullable(clazz.cast(this.resultStatusAsString()));
            }
            case "email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "userFullName": {
                return Optional.ofNullable(clazz.cast(this.userFullName()));
            }
            case "userFirstName": {
                return Optional.ofNullable(clazz.cast(this.userFirstName()));
            }
            case "userLastName": {
                return Optional.ofNullable(clazz.cast(this.userLastName()));
            }
            case "userStatus": {
                return Optional.ofNullable(clazz.cast(this.userStatus()));
            }
            case "taskError": {
                return Optional.ofNullable(clazz.cast(this.taskError()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserAccessResultItem, T> g) {
        return obj -> g.apply((UserAccessResultItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String app;
        private String tenantId;
        private String tenantDisplayName;
        private String taskId;
        private String resultStatus;
        private String email;
        private String userId;
        private String userFullName;
        private String userFirstName;
        private String userLastName;
        private String userStatus;
        private TaskError taskError;

        private BuilderImpl() {
        }

        private BuilderImpl(UserAccessResultItem model) {
            this.app(model.app);
            this.tenantId(model.tenantId);
            this.tenantDisplayName(model.tenantDisplayName);
            this.taskId(model.taskId);
            this.resultStatus(model.resultStatus);
            this.email(model.email);
            this.userId(model.userId);
            this.userFullName(model.userFullName);
            this.userFirstName(model.userFirstName);
            this.userLastName(model.userLastName);
            this.userStatus(model.userStatus);
            this.taskError(model.taskError);
        }

        public final String getApp() {
            return this.app;
        }

        public final void setApp(String app) {
            this.app = app;
        }

        @Override
        public final Builder app(String app) {
            this.app = app;
            return this;
        }

        public final String getTenantId() {
            return this.tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getTenantDisplayName() {
            return this.tenantDisplayName;
        }

        public final void setTenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
        }

        @Override
        public final Builder tenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
            return this;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getResultStatus() {
            return this.resultStatus;
        }

        public final void setResultStatus(String resultStatus) {
            this.resultStatus = resultStatus;
        }

        @Override
        public final Builder resultStatus(String resultStatus) {
            this.resultStatus = resultStatus;
            return this;
        }

        @Override
        public final Builder resultStatus(ResultStatus resultStatus) {
            this.resultStatus(resultStatus == null ? null : resultStatus.toString());
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getUserFullName() {
            return this.userFullName;
        }

        public final void setUserFullName(String userFullName) {
            this.userFullName = userFullName;
        }

        @Override
        public final Builder userFullName(String userFullName) {
            this.userFullName = userFullName;
            return this;
        }

        public final String getUserFirstName() {
            return this.userFirstName;
        }

        public final void setUserFirstName(String userFirstName) {
            this.userFirstName = userFirstName;
        }

        @Override
        public final Builder userFirstName(String userFirstName) {
            this.userFirstName = userFirstName;
            return this;
        }

        public final String getUserLastName() {
            return this.userLastName;
        }

        public final void setUserLastName(String userLastName) {
            this.userLastName = userLastName;
        }

        @Override
        public final Builder userLastName(String userLastName) {
            this.userLastName = userLastName;
            return this;
        }

        public final String getUserStatus() {
            return this.userStatus;
        }

        public final void setUserStatus(String userStatus) {
            this.userStatus = userStatus;
        }

        @Override
        public final Builder userStatus(String userStatus) {
            this.userStatus = userStatus;
            return this;
        }

        public final TaskError.Builder getTaskError() {
            return this.taskError != null ? this.taskError.toBuilder() : null;
        }

        public final void setTaskError(TaskError.BuilderImpl taskError) {
            this.taskError = taskError != null ? taskError.build() : null;
        }

        @Override
        public final Builder taskError(TaskError taskError) {
            this.taskError = taskError;
            return this;
        }

        public UserAccessResultItem build() {
            return new UserAccessResultItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserAccessResultItem> {
        public Builder app(String var1);

        public Builder tenantId(String var1);

        public Builder tenantDisplayName(String var1);

        public Builder taskId(String var1);

        public Builder resultStatus(String var1);

        public Builder resultStatus(ResultStatus var1);

        public Builder email(String var1);

        public Builder userId(String var1);

        public Builder userFullName(String var1);

        public Builder userFirstName(String var1);

        public Builder userLastName(String var1);

        public Builder userStatus(String var1);

        public Builder taskError(TaskError var1);

        default public Builder taskError(Consumer<TaskError.Builder> taskError) {
            return this.taskError((TaskError)((TaskError.Builder)TaskError.builder().applyMutation(taskError)).build());
        }
    }
}

