/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appfabric.AppFabricClient;
import software.amazon.awssdk.services.appfabric.model.AppAuthorizationSummary;
import software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsRequest;
import software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsResponse;

public class ListAppAuthorizationsIterable
implements SdkIterable<ListAppAuthorizationsResponse> {
    private final AppFabricClient client;
    private final ListAppAuthorizationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppAuthorizationsIterable(AppFabricClient client, ListAppAuthorizationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAppAuthorizationsResponseFetcher();
    }

    public Iterator<ListAppAuthorizationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AppAuthorizationSummary> appAuthorizationSummaryList() {
        Function<ListAppAuthorizationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.appAuthorizationSummaryList() != null) {
                return response.appAuthorizationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAppAuthorizationsResponseFetcher
    implements SyncPageFetcher<ListAppAuthorizationsResponse> {
        private ListAppAuthorizationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppAuthorizationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppAuthorizationsResponse nextPage(ListAppAuthorizationsResponse previousPage) {
            if (previousPage == null) {
                return ListAppAuthorizationsIterable.this.client.listAppAuthorizations(ListAppAuthorizationsIterable.this.firstRequest);
            }
            return ListAppAuthorizationsIterable.this.client.listAppAuthorizations((ListAppAuthorizationsRequest)((Object)ListAppAuthorizationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

