/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appfabric.model.AppFabricRequest;
import software.amazon.awssdk.services.appfabric.model.Credential;
import software.amazon.awssdk.services.appfabric.model.Tenant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAppAuthorizationRequest
extends AppFabricRequest
implements ToCopyableBuilder<Builder, UpdateAppAuthorizationRequest> {
    private static final SdkField<String> APP_BUNDLE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appBundleIdentifier").getter(UpdateAppAuthorizationRequest.getter(UpdateAppAuthorizationRequest::appBundleIdentifier)).setter(UpdateAppAuthorizationRequest.setter(Builder::appBundleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appBundleIdentifier").build()}).build();
    private static final SdkField<String> APP_AUTHORIZATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appAuthorizationIdentifier").getter(UpdateAppAuthorizationRequest.getter(UpdateAppAuthorizationRequest::appAuthorizationIdentifier)).setter(UpdateAppAuthorizationRequest.setter(Builder::appAuthorizationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appAuthorizationIdentifier").build()}).build();
    private static final SdkField<Credential> CREDENTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("credential").getter(UpdateAppAuthorizationRequest.getter(UpdateAppAuthorizationRequest::credential)).setter(UpdateAppAuthorizationRequest.setter(Builder::credential)).constructor(Credential::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credential").build()}).build();
    private static final SdkField<Tenant> TENANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tenant").getter(UpdateAppAuthorizationRequest.getter(UpdateAppAuthorizationRequest::tenant)).setter(UpdateAppAuthorizationRequest.setter(Builder::tenant)).constructor(Tenant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenant").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BUNDLE_IDENTIFIER_FIELD, APP_AUTHORIZATION_IDENTIFIER_FIELD, CREDENTIAL_FIELD, TENANT_FIELD));
    private final String appBundleIdentifier;
    private final String appAuthorizationIdentifier;
    private final Credential credential;
    private final Tenant tenant;

    private UpdateAppAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.appBundleIdentifier = builder.appBundleIdentifier;
        this.appAuthorizationIdentifier = builder.appAuthorizationIdentifier;
        this.credential = builder.credential;
        this.tenant = builder.tenant;
    }

    public final String appBundleIdentifier() {
        return this.appBundleIdentifier;
    }

    public final String appAuthorizationIdentifier() {
        return this.appAuthorizationIdentifier;
    }

    public final Credential credential() {
        return this.credential;
    }

    public final Tenant tenant() {
        return this.tenant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appBundleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.appAuthorizationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.credential());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenant());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppAuthorizationRequest)) {
            return false;
        }
        UpdateAppAuthorizationRequest other = (UpdateAppAuthorizationRequest)((Object)obj);
        return Objects.equals(this.appBundleIdentifier(), other.appBundleIdentifier()) && Objects.equals(this.appAuthorizationIdentifier(), other.appAuthorizationIdentifier()) && Objects.equals(this.credential(), other.credential()) && Objects.equals(this.tenant(), other.tenant());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAppAuthorizationRequest").add("AppBundleIdentifier", (Object)this.appBundleIdentifier()).add("AppAuthorizationIdentifier", (Object)this.appAuthorizationIdentifier()).add("Credential", (Object)this.credential()).add("Tenant", (Object)this.tenant()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appBundleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.appBundleIdentifier()));
            }
            case "appAuthorizationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.appAuthorizationIdentifier()));
            }
            case "credential": {
                return Optional.ofNullable(clazz.cast(this.credential()));
            }
            case "tenant": {
                return Optional.ofNullable(clazz.cast(this.tenant()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppAuthorizationRequest, T> g) {
        return obj -> g.apply((UpdateAppAuthorizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppFabricRequest.BuilderImpl
    implements Builder {
        private String appBundleIdentifier;
        private String appAuthorizationIdentifier;
        private Credential credential;
        private Tenant tenant;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppAuthorizationRequest model) {
            super(model);
            this.appBundleIdentifier(model.appBundleIdentifier);
            this.appAuthorizationIdentifier(model.appAuthorizationIdentifier);
            this.credential(model.credential);
            this.tenant(model.tenant);
        }

        public final String getAppBundleIdentifier() {
            return this.appBundleIdentifier;
        }

        public final void setAppBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
        }

        @Override
        public final Builder appBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
            return this;
        }

        public final String getAppAuthorizationIdentifier() {
            return this.appAuthorizationIdentifier;
        }

        public final void setAppAuthorizationIdentifier(String appAuthorizationIdentifier) {
            this.appAuthorizationIdentifier = appAuthorizationIdentifier;
        }

        @Override
        public final Builder appAuthorizationIdentifier(String appAuthorizationIdentifier) {
            this.appAuthorizationIdentifier = appAuthorizationIdentifier;
            return this;
        }

        public final Credential.Builder getCredential() {
            return this.credential != null ? this.credential.toBuilder() : null;
        }

        public final void setCredential(Credential.BuilderImpl credential) {
            this.credential = credential != null ? credential.build() : null;
        }

        @Override
        public final Builder credential(Credential credential) {
            this.credential = credential;
            return this;
        }

        public final Tenant.Builder getTenant() {
            return this.tenant != null ? this.tenant.toBuilder() : null;
        }

        public final void setTenant(Tenant.BuilderImpl tenant) {
            this.tenant = tenant != null ? tenant.build() : null;
        }

        @Override
        public final Builder tenant(Tenant tenant) {
            this.tenant = tenant;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAppAuthorizationRequest build() {
            return new UpdateAppAuthorizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppFabricRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAppAuthorizationRequest> {
        public Builder appBundleIdentifier(String var1);

        public Builder appAuthorizationIdentifier(String var1);

        public Builder credential(Credential var1);

        default public Builder credential(Consumer<Credential.Builder> credential) {
            return this.credential((Credential)((Credential.Builder)Credential.builder().applyMutation(credential)).build());
        }

        public Builder tenant(Tenant var1);

        default public Builder tenant(Consumer<Tenant.Builder> tenant) {
            return this.tenant((Tenant)((Tenant.Builder)Tenant.builder().applyMutation(tenant)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

