/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a user's access to an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserAccessResultItem implements SdkPojo, Serializable,
        ToCopyableBuilder<UserAccessResultItem.Builder, UserAccessResultItem> {
    private static final SdkField<String> APP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("app")
            .getter(getter(UserAccessResultItem::app)).setter(setter(Builder::app))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("app").build()).build();

    private static final SdkField<String> TENANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tenantId").getter(getter(UserAccessResultItem::tenantId)).setter(setter(Builder::tenantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenantId").build()).build();

    private static final SdkField<String> TENANT_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tenantDisplayName").getter(getter(UserAccessResultItem::tenantDisplayName))
            .setter(setter(Builder::tenantDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenantDisplayName").build()).build();

    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(UserAccessResultItem::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<String> RESULT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resultStatus").getter(getter(UserAccessResultItem::resultStatusAsString))
            .setter(setter(Builder::resultStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultStatus").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("email")
            .getter(getter(UserAccessResultItem::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(UserAccessResultItem::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<String> USER_FULL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userFullName").getter(getter(UserAccessResultItem::userFullName)).setter(setter(Builder::userFullName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userFullName").build()).build();

    private static final SdkField<String> USER_FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userFirstName").getter(getter(UserAccessResultItem::userFirstName))
            .setter(setter(Builder::userFirstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userFirstName").build()).build();

    private static final SdkField<String> USER_LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userLastName").getter(getter(UserAccessResultItem::userLastName)).setter(setter(Builder::userLastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userLastName").build()).build();

    private static final SdkField<String> USER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userStatus").getter(getter(UserAccessResultItem::userStatus)).setter(setter(Builder::userStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userStatus").build()).build();

    private static final SdkField<TaskError> TASK_ERROR_FIELD = SdkField.<TaskError> builder(MarshallingType.SDK_POJO)
            .memberName("taskError").getter(getter(UserAccessResultItem::taskError)).setter(setter(Builder::taskError))
            .constructor(TaskError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskError").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_FIELD, TENANT_ID_FIELD,
            TENANT_DISPLAY_NAME_FIELD, TASK_ID_FIELD, RESULT_STATUS_FIELD, EMAIL_FIELD, USER_ID_FIELD, USER_FULL_NAME_FIELD,
            USER_FIRST_NAME_FIELD, USER_LAST_NAME_FIELD, USER_STATUS_FIELD, TASK_ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String app;

    private final String tenantId;

    private final String tenantDisplayName;

    private final String taskId;

    private final String resultStatus;

    private final String email;

    private final String userId;

    private final String userFullName;

    private final String userFirstName;

    private final String userLastName;

    private final String userStatus;

    private final TaskError taskError;

    private UserAccessResultItem(BuilderImpl builder) {
        this.app = builder.app;
        this.tenantId = builder.tenantId;
        this.tenantDisplayName = builder.tenantDisplayName;
        this.taskId = builder.taskId;
        this.resultStatus = builder.resultStatus;
        this.email = builder.email;
        this.userId = builder.userId;
        this.userFullName = builder.userFullName;
        this.userFirstName = builder.userFirstName;
        this.userLastName = builder.userLastName;
        this.userStatus = builder.userStatus;
        this.taskError = builder.taskError;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String app() {
        return app;
    }

    /**
     * <p>
     * The ID of the application tenant.
     * </p>
     * 
     * @return The ID of the application tenant.
     */
    public final String tenantId() {
        return tenantId;
    }

    /**
     * <p>
     * The display name of the tenant.
     * </p>
     * 
     * @return The display name of the tenant.
     */
    public final String tenantDisplayName() {
        return tenantDisplayName;
    }

    /**
     * <p>
     * The unique ID of the task.
     * </p>
     * 
     * @return The unique ID of the task.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The status of the user access result item.
     * </p>
     * <p>
     * The following states are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code>: The user access task is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code>: The user access task completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The user access task failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPIRED</code>: The user access task expired.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultStatus} will
     * return {@link ResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultStatusAsString}.
     * </p>
     * 
     * @return The status of the user access result item.</p>
     *         <p>
     *         The following states are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code>: The user access task is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code>: The user access task completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The user access task failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXPIRED</code>: The user access task expired.
     *         </p>
     *         </li>
     * @see ResultStatus
     */
    public final ResultStatus resultStatus() {
        return ResultStatus.fromValue(resultStatus);
    }

    /**
     * <p>
     * The status of the user access result item.
     * </p>
     * <p>
     * The following states are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code>: The user access task is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code>: The user access task completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The user access task failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPIRED</code>: The user access task expired.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultStatus} will
     * return {@link ResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultStatusAsString}.
     * </p>
     * 
     * @return The status of the user access result item.</p>
     *         <p>
     *         The following states are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code>: The user access task is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code>: The user access task completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The user access task failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXPIRED</code>: The user access task expired.
     *         </p>
     *         </li>
     * @see ResultStatus
     */
    public final String resultStatusAsString() {
        return resultStatus;
    }

    /**
     * <p>
     * The email address of the target user.
     * </p>
     * 
     * @return The email address of the target user.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * The unique ID of user.
     * </p>
     * 
     * @return The unique ID of user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The full name of the user.
     * </p>
     * 
     * @return The full name of the user.
     */
    public final String userFullName() {
        return userFullName;
    }

    /**
     * <p>
     * The first name of the user.
     * </p>
     * 
     * @return The first name of the user.
     */
    public final String userFirstName() {
        return userFirstName;
    }

    /**
     * <p>
     * The last name of the user.
     * </p>
     * 
     * @return The last name of the user.
     */
    public final String userLastName() {
        return userLastName;
    }

    /**
     * <p>
     * The status of the user returned by the application.
     * </p>
     * 
     * @return The status of the user returned by the application.
     */
    public final String userStatus() {
        return userStatus;
    }

    /**
     * <p>
     * Contains information about an error returned from a user access task.
     * </p>
     * 
     * @return Contains information about an error returned from a user access task.
     */
    public final TaskError taskError() {
        return taskError;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(app());
        hashCode = 31 * hashCode + Objects.hashCode(tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(tenantDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(resultStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(userFullName());
        hashCode = 31 * hashCode + Objects.hashCode(userFirstName());
        hashCode = 31 * hashCode + Objects.hashCode(userLastName());
        hashCode = 31 * hashCode + Objects.hashCode(userStatus());
        hashCode = 31 * hashCode + Objects.hashCode(taskError());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserAccessResultItem)) {
            return false;
        }
        UserAccessResultItem other = (UserAccessResultItem) obj;
        return Objects.equals(app(), other.app()) && Objects.equals(tenantId(), other.tenantId())
                && Objects.equals(tenantDisplayName(), other.tenantDisplayName()) && Objects.equals(taskId(), other.taskId())
                && Objects.equals(resultStatusAsString(), other.resultStatusAsString()) && Objects.equals(email(), other.email())
                && Objects.equals(userId(), other.userId()) && Objects.equals(userFullName(), other.userFullName())
                && Objects.equals(userFirstName(), other.userFirstName()) && Objects.equals(userLastName(), other.userLastName())
                && Objects.equals(userStatus(), other.userStatus()) && Objects.equals(taskError(), other.taskError());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserAccessResultItem").add("App", app()).add("TenantId", tenantId())
                .add("TenantDisplayName", tenantDisplayName()).add("TaskId", taskId())
                .add("ResultStatus", resultStatusAsString())
                .add("Email", email() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UserId", userId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UserFullName", userFullName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UserFirstName", userFirstName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UserLastName", userLastName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UserStatus", userStatus()).add("TaskError", taskError()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "app":
            return Optional.ofNullable(clazz.cast(app()));
        case "tenantId":
            return Optional.ofNullable(clazz.cast(tenantId()));
        case "tenantDisplayName":
            return Optional.ofNullable(clazz.cast(tenantDisplayName()));
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "resultStatus":
            return Optional.ofNullable(clazz.cast(resultStatusAsString()));
        case "email":
            return Optional.ofNullable(clazz.cast(email()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "userFullName":
            return Optional.ofNullable(clazz.cast(userFullName()));
        case "userFirstName":
            return Optional.ofNullable(clazz.cast(userFirstName()));
        case "userLastName":
            return Optional.ofNullable(clazz.cast(userLastName()));
        case "userStatus":
            return Optional.ofNullable(clazz.cast(userStatus()));
        case "taskError":
            return Optional.ofNullable(clazz.cast(taskError()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserAccessResultItem, T> g) {
        return obj -> g.apply((UserAccessResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserAccessResultItem> {
        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param app
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder app(String app);

        /**
         * <p>
         * The ID of the application tenant.
         * </p>
         * 
         * @param tenantId
         *        The ID of the application tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantId(String tenantId);

        /**
         * <p>
         * The display name of the tenant.
         * </p>
         * 
         * @param tenantDisplayName
         *        The display name of the tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantDisplayName(String tenantDisplayName);

        /**
         * <p>
         * The unique ID of the task.
         * </p>
         * 
         * @param taskId
         *        The unique ID of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The status of the user access result item.
         * </p>
         * <p>
         * The following states are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>: The user access task is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code>: The user access task completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The user access task failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXPIRED</code>: The user access task expired.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resultStatus
         *        The status of the user access result item.</p>
         *        <p>
         *        The following states are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>: The user access task is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code>: The user access task completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The user access task failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXPIRED</code>: The user access task expired.
         *        </p>
         *        </li>
         * @see ResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResultStatus
         */
        Builder resultStatus(String resultStatus);

        /**
         * <p>
         * The status of the user access result item.
         * </p>
         * <p>
         * The following states are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>: The user access task is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code>: The user access task completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The user access task failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXPIRED</code>: The user access task expired.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resultStatus
         *        The status of the user access result item.</p>
         *        <p>
         *        The following states are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>: The user access task is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code>: The user access task completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The user access task failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXPIRED</code>: The user access task expired.
         *        </p>
         *        </li>
         * @see ResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResultStatus
         */
        Builder resultStatus(ResultStatus resultStatus);

        /**
         * <p>
         * The email address of the target user.
         * </p>
         * 
         * @param email
         *        The email address of the target user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The unique ID of user.
         * </p>
         * 
         * @param userId
         *        The unique ID of user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The full name of the user.
         * </p>
         * 
         * @param userFullName
         *        The full name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userFullName(String userFullName);

        /**
         * <p>
         * The first name of the user.
         * </p>
         * 
         * @param userFirstName
         *        The first name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userFirstName(String userFirstName);

        /**
         * <p>
         * The last name of the user.
         * </p>
         * 
         * @param userLastName
         *        The last name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userLastName(String userLastName);

        /**
         * <p>
         * The status of the user returned by the application.
         * </p>
         * 
         * @param userStatus
         *        The status of the user returned by the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userStatus(String userStatus);

        /**
         * <p>
         * Contains information about an error returned from a user access task.
         * </p>
         * 
         * @param taskError
         *        Contains information about an error returned from a user access task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskError(TaskError taskError);

        /**
         * <p>
         * Contains information about an error returned from a user access task.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskError.Builder} avoiding the need to
         * create one manually via {@link TaskError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskError.Builder#build()} is called immediately and its result
         * is passed to {@link #taskError(TaskError)}.
         * 
         * @param taskError
         *        a consumer that will call methods on {@link TaskError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskError(TaskError)
         */
        default Builder taskError(Consumer<TaskError.Builder> taskError) {
            return taskError(TaskError.builder().applyMutation(taskError).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String app;

        private String tenantId;

        private String tenantDisplayName;

        private String taskId;

        private String resultStatus;

        private String email;

        private String userId;

        private String userFullName;

        private String userFirstName;

        private String userLastName;

        private String userStatus;

        private TaskError taskError;

        private BuilderImpl() {
        }

        private BuilderImpl(UserAccessResultItem model) {
            app(model.app);
            tenantId(model.tenantId);
            tenantDisplayName(model.tenantDisplayName);
            taskId(model.taskId);
            resultStatus(model.resultStatus);
            email(model.email);
            userId(model.userId);
            userFullName(model.userFullName);
            userFirstName(model.userFirstName);
            userLastName(model.userLastName);
            userStatus(model.userStatus);
            taskError(model.taskError);
        }

        public final String getApp() {
            return app;
        }

        public final void setApp(String app) {
            this.app = app;
        }

        @Override
        public final Builder app(String app) {
            this.app = app;
            return this;
        }

        public final String getTenantId() {
            return tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getTenantDisplayName() {
            return tenantDisplayName;
        }

        public final void setTenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
        }

        @Override
        public final Builder tenantDisplayName(String tenantDisplayName) {
            this.tenantDisplayName = tenantDisplayName;
            return this;
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getResultStatus() {
            return resultStatus;
        }

        public final void setResultStatus(String resultStatus) {
            this.resultStatus = resultStatus;
        }

        @Override
        public final Builder resultStatus(String resultStatus) {
            this.resultStatus = resultStatus;
            return this;
        }

        @Override
        public final Builder resultStatus(ResultStatus resultStatus) {
            this.resultStatus(resultStatus == null ? null : resultStatus.toString());
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getUserFullName() {
            return userFullName;
        }

        public final void setUserFullName(String userFullName) {
            this.userFullName = userFullName;
        }

        @Override
        public final Builder userFullName(String userFullName) {
            this.userFullName = userFullName;
            return this;
        }

        public final String getUserFirstName() {
            return userFirstName;
        }

        public final void setUserFirstName(String userFirstName) {
            this.userFirstName = userFirstName;
        }

        @Override
        public final Builder userFirstName(String userFirstName) {
            this.userFirstName = userFirstName;
            return this;
        }

        public final String getUserLastName() {
            return userLastName;
        }

        public final void setUserLastName(String userLastName) {
            this.userLastName = userLastName;
        }

        @Override
        public final Builder userLastName(String userLastName) {
            this.userLastName = userLastName;
            return this;
        }

        public final String getUserStatus() {
            return userStatus;
        }

        public final void setUserStatus(String userStatus) {
            this.userStatus = userStatus;
        }

        @Override
        public final Builder userStatus(String userStatus) {
            this.userStatus = userStatus;
            return this;
        }

        public final TaskError.Builder getTaskError() {
            return taskError != null ? taskError.toBuilder() : null;
        }

        public final void setTaskError(TaskError.BuilderImpl taskError) {
            this.taskError = taskError != null ? taskError.build() : null;
        }

        @Override
        public final Builder taskError(TaskError taskError) {
            this.taskError = taskError;
            return this;
        }

        @Override
        public UserAccessResultItem build() {
            return new UserAccessResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
