/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectAppAuthorizationResponse extends AppFabricResponse implements
        ToCopyableBuilder<ConnectAppAuthorizationResponse.Builder, ConnectAppAuthorizationResponse> {
    private static final SdkField<AppAuthorizationSummary> APP_AUTHORIZATION_SUMMARY_FIELD = SdkField
            .<AppAuthorizationSummary> builder(MarshallingType.SDK_POJO).memberName("appAuthorizationSummary")
            .getter(getter(ConnectAppAuthorizationResponse::appAuthorizationSummary))
            .setter(setter(Builder::appAuthorizationSummary)).constructor(AppAuthorizationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appAuthorizationSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APP_AUTHORIZATION_SUMMARY_FIELD));

    private final AppAuthorizationSummary appAuthorizationSummary;

    private ConnectAppAuthorizationResponse(BuilderImpl builder) {
        super(builder);
        this.appAuthorizationSummary = builder.appAuthorizationSummary;
    }

    /**
     * <p>
     * Contains a summary of the app authorization.
     * </p>
     * 
     * @return Contains a summary of the app authorization.
     */
    public final AppAuthorizationSummary appAuthorizationSummary() {
        return appAuthorizationSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appAuthorizationSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectAppAuthorizationResponse)) {
            return false;
        }
        ConnectAppAuthorizationResponse other = (ConnectAppAuthorizationResponse) obj;
        return Objects.equals(appAuthorizationSummary(), other.appAuthorizationSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectAppAuthorizationResponse").add("AppAuthorizationSummary", appAuthorizationSummary())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appAuthorizationSummary":
            return Optional.ofNullable(clazz.cast(appAuthorizationSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectAppAuthorizationResponse, T> g) {
        return obj -> g.apply((ConnectAppAuthorizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppFabricResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ConnectAppAuthorizationResponse> {
        /**
         * <p>
         * Contains a summary of the app authorization.
         * </p>
         * 
         * @param appAuthorizationSummary
         *        Contains a summary of the app authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appAuthorizationSummary(AppAuthorizationSummary appAuthorizationSummary);

        /**
         * <p>
         * Contains a summary of the app authorization.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppAuthorizationSummary.Builder} avoiding
         * the need to create one manually via {@link AppAuthorizationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppAuthorizationSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #appAuthorizationSummary(AppAuthorizationSummary)}.
         * 
         * @param appAuthorizationSummary
         *        a consumer that will call methods on {@link AppAuthorizationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appAuthorizationSummary(AppAuthorizationSummary)
         */
        default Builder appAuthorizationSummary(Consumer<AppAuthorizationSummary.Builder> appAuthorizationSummary) {
            return appAuthorizationSummary(AppAuthorizationSummary.builder().applyMutation(appAuthorizationSummary).build());
        }
    }

    static final class BuilderImpl extends AppFabricResponse.BuilderImpl implements Builder {
        private AppAuthorizationSummary appAuthorizationSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectAppAuthorizationResponse model) {
            super(model);
            appAuthorizationSummary(model.appAuthorizationSummary);
        }

        public final AppAuthorizationSummary.Builder getAppAuthorizationSummary() {
            return appAuthorizationSummary != null ? appAuthorizationSummary.toBuilder() : null;
        }

        public final void setAppAuthorizationSummary(AppAuthorizationSummary.BuilderImpl appAuthorizationSummary) {
            this.appAuthorizationSummary = appAuthorizationSummary != null ? appAuthorizationSummary.build() : null;
        }

        @Override
        public final Builder appAuthorizationSummary(AppAuthorizationSummary appAuthorizationSummary) {
            this.appAuthorizationSummary = appAuthorizationSummary;
            return this;
        }

        @Override
        public ConnectAppAuthorizationResponse build() {
            return new ConnectAppAuthorizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
