/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appconfig.model.AppConfigResponse;
import software.amazon.awssdk.services.appconfig.model.AppliedExtension;
import software.amazon.awssdk.services.appconfig.model.AppliedExtensionsCopier;
import software.amazon.awssdk.services.appconfig.model.DeploymentEvent;
import software.amazon.awssdk.services.appconfig.model.DeploymentEventsCopier;
import software.amazon.awssdk.services.appconfig.model.DeploymentState;
import software.amazon.awssdk.services.appconfig.model.GrowthType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopDeploymentResponse
extends AppConfigResponse
implements ToCopyableBuilder<Builder, StopDeploymentResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(StopDeploymentResponse.getter(StopDeploymentResponse::applicationId)).setter(StopDeploymentResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentId").getter(StopDeploymentResponse.getter(StopDeploymentResponse::environmentId)).setter(StopDeploymentResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STRATEGY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentStrategyId").getter(StopDeploymentResponse.getter(StopDeploymentResponse::deploymentStrategyId)).setter(StopDeploymentResponse.setter(Builder::deploymentStrategyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStrategyId").build()}).build();
    private static final SdkField<String> CONFIGURATION_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationProfileId").getter(StopDeploymentResponse.getter(StopDeploymentResponse::configurationProfileId)).setter(StopDeploymentResponse.setter(Builder::configurationProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationProfileId").build()}).build();
    private static final SdkField<Integer> DEPLOYMENT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DeploymentNumber").getter(StopDeploymentResponse.getter(StopDeploymentResponse::deploymentNumber)).setter(StopDeploymentResponse.setter(Builder::deploymentNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentNumber").build()}).build();
    private static final SdkField<String> CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationName").getter(StopDeploymentResponse.getter(StopDeploymentResponse::configurationName)).setter(StopDeploymentResponse.setter(Builder::configurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationName").build()}).build();
    private static final SdkField<String> CONFIGURATION_LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationLocationUri").getter(StopDeploymentResponse.getter(StopDeploymentResponse::configurationLocationUri)).setter(StopDeploymentResponse.setter(Builder::configurationLocationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationLocationUri").build()}).build();
    private static final SdkField<String> CONFIGURATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationVersion").getter(StopDeploymentResponse.getter(StopDeploymentResponse::configurationVersion)).setter(StopDeploymentResponse.setter(Builder::configurationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StopDeploymentResponse.getter(StopDeploymentResponse::description)).setter(StopDeploymentResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> DEPLOYMENT_DURATION_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DeploymentDurationInMinutes").getter(StopDeploymentResponse.getter(StopDeploymentResponse::deploymentDurationInMinutes)).setter(StopDeploymentResponse.setter(Builder::deploymentDurationInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentDurationInMinutes").build()}).build();
    private static final SdkField<String> GROWTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrowthType").getter(StopDeploymentResponse.getter(StopDeploymentResponse::growthTypeAsString)).setter(StopDeploymentResponse.setter(Builder::growthType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthType").build()}).build();
    private static final SdkField<Float> GROWTH_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("GrowthFactor").getter(StopDeploymentResponse.getter(StopDeploymentResponse::growthFactor)).setter(StopDeploymentResponse.setter(Builder::growthFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthFactor").build()}).build();
    private static final SdkField<Integer> FINAL_BAKE_TIME_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FinalBakeTimeInMinutes").getter(StopDeploymentResponse.getter(StopDeploymentResponse::finalBakeTimeInMinutes)).setter(StopDeploymentResponse.setter(Builder::finalBakeTimeInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBakeTimeInMinutes").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(StopDeploymentResponse.getter(StopDeploymentResponse::stateAsString)).setter(StopDeploymentResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<List<DeploymentEvent>> EVENT_LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventLog").getter(StopDeploymentResponse.getter(StopDeploymentResponse::eventLog)).setter(StopDeploymentResponse.setter(Builder::eventLog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventLog").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeploymentEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Float> PERCENTAGE_COMPLETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("PercentageComplete").getter(StopDeploymentResponse.getter(StopDeploymentResponse::percentageComplete)).setter(StopDeploymentResponse.setter(Builder::percentageComplete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageComplete").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedAt").getter(StopDeploymentResponse.getter(StopDeploymentResponse::startedAt)).setter(StopDeploymentResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedAt").getter(StopDeploymentResponse.getter(StopDeploymentResponse::completedAt)).setter(StopDeploymentResponse.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<AppliedExtension>> APPLIED_EXTENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppliedExtensions").getter(StopDeploymentResponse.getter(StopDeploymentResponse::appliedExtensions)).setter(StopDeploymentResponse.setter(Builder::appliedExtensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedExtensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppliedExtension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(StopDeploymentResponse.getter(StopDeploymentResponse::kmsKeyArn)).setter(StopDeploymentResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyIdentifier").getter(StopDeploymentResponse.getter(StopDeploymentResponse::kmsKeyIdentifier)).setter(StopDeploymentResponse.setter(Builder::kmsKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, ENVIRONMENT_ID_FIELD, DEPLOYMENT_STRATEGY_ID_FIELD, CONFIGURATION_PROFILE_ID_FIELD, DEPLOYMENT_NUMBER_FIELD, CONFIGURATION_NAME_FIELD, CONFIGURATION_LOCATION_URI_FIELD, CONFIGURATION_VERSION_FIELD, DESCRIPTION_FIELD, DEPLOYMENT_DURATION_IN_MINUTES_FIELD, GROWTH_TYPE_FIELD, GROWTH_FACTOR_FIELD, FINAL_BAKE_TIME_IN_MINUTES_FIELD, STATE_FIELD, EVENT_LOG_FIELD, PERCENTAGE_COMPLETE_FIELD, STARTED_AT_FIELD, COMPLETED_AT_FIELD, APPLIED_EXTENSIONS_FIELD, KMS_KEY_ARN_FIELD, KMS_KEY_IDENTIFIER_FIELD));
    private final String applicationId;
    private final String environmentId;
    private final String deploymentStrategyId;
    private final String configurationProfileId;
    private final Integer deploymentNumber;
    private final String configurationName;
    private final String configurationLocationUri;
    private final String configurationVersion;
    private final String description;
    private final Integer deploymentDurationInMinutes;
    private final String growthType;
    private final Float growthFactor;
    private final Integer finalBakeTimeInMinutes;
    private final String state;
    private final List<DeploymentEvent> eventLog;
    private final Float percentageComplete;
    private final Instant startedAt;
    private final Instant completedAt;
    private final List<AppliedExtension> appliedExtensions;
    private final String kmsKeyArn;
    private final String kmsKeyIdentifier;

    private StopDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.environmentId = builder.environmentId;
        this.deploymentStrategyId = builder.deploymentStrategyId;
        this.configurationProfileId = builder.configurationProfileId;
        this.deploymentNumber = builder.deploymentNumber;
        this.configurationName = builder.configurationName;
        this.configurationLocationUri = builder.configurationLocationUri;
        this.configurationVersion = builder.configurationVersion;
        this.description = builder.description;
        this.deploymentDurationInMinutes = builder.deploymentDurationInMinutes;
        this.growthType = builder.growthType;
        this.growthFactor = builder.growthFactor;
        this.finalBakeTimeInMinutes = builder.finalBakeTimeInMinutes;
        this.state = builder.state;
        this.eventLog = builder.eventLog;
        this.percentageComplete = builder.percentageComplete;
        this.startedAt = builder.startedAt;
        this.completedAt = builder.completedAt;
        this.appliedExtensions = builder.appliedExtensions;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String deploymentStrategyId() {
        return this.deploymentStrategyId;
    }

    public final String configurationProfileId() {
        return this.configurationProfileId;
    }

    public final Integer deploymentNumber() {
        return this.deploymentNumber;
    }

    public final String configurationName() {
        return this.configurationName;
    }

    public final String configurationLocationUri() {
        return this.configurationLocationUri;
    }

    public final String configurationVersion() {
        return this.configurationVersion;
    }

    public final String description() {
        return this.description;
    }

    public final Integer deploymentDurationInMinutes() {
        return this.deploymentDurationInMinutes;
    }

    public final GrowthType growthType() {
        return GrowthType.fromValue(this.growthType);
    }

    public final String growthTypeAsString() {
        return this.growthType;
    }

    public final Float growthFactor() {
        return this.growthFactor;
    }

    public final Integer finalBakeTimeInMinutes() {
        return this.finalBakeTimeInMinutes;
    }

    public final DeploymentState state() {
        return DeploymentState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasEventLog() {
        return this.eventLog != null && !(this.eventLog instanceof SdkAutoConstructList);
    }

    public final List<DeploymentEvent> eventLog() {
        return this.eventLog;
    }

    public final Float percentageComplete() {
        return this.percentageComplete;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant completedAt() {
        return this.completedAt;
    }

    public final boolean hasAppliedExtensions() {
        return this.appliedExtensions != null && !(this.appliedExtensions instanceof SdkAutoConstructList);
    }

    public final List<AppliedExtension> appliedExtensions() {
        return this.appliedExtensions;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStrategyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationLocationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.growthTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.growthFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalBakeTimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventLog() ? this.eventLog() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.percentageComplete());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppliedExtensions() ? this.appliedExtensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopDeploymentResponse)) {
            return false;
        }
        StopDeploymentResponse other = (StopDeploymentResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.deploymentStrategyId(), other.deploymentStrategyId()) && Objects.equals(this.configurationProfileId(), other.configurationProfileId()) && Objects.equals(this.deploymentNumber(), other.deploymentNumber()) && Objects.equals(this.configurationName(), other.configurationName()) && Objects.equals(this.configurationLocationUri(), other.configurationLocationUri()) && Objects.equals(this.configurationVersion(), other.configurationVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.deploymentDurationInMinutes(), other.deploymentDurationInMinutes()) && Objects.equals(this.growthTypeAsString(), other.growthTypeAsString()) && Objects.equals(this.growthFactor(), other.growthFactor()) && Objects.equals(this.finalBakeTimeInMinutes(), other.finalBakeTimeInMinutes()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasEventLog() == other.hasEventLog() && Objects.equals(this.eventLog(), other.eventLog()) && Objects.equals(this.percentageComplete(), other.percentageComplete()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.completedAt(), other.completedAt()) && this.hasAppliedExtensions() == other.hasAppliedExtensions() && Objects.equals(this.appliedExtensions(), other.appliedExtensions()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"StopDeploymentResponse").add("ApplicationId", (Object)this.applicationId()).add("EnvironmentId", (Object)this.environmentId()).add("DeploymentStrategyId", (Object)this.deploymentStrategyId()).add("ConfigurationProfileId", (Object)this.configurationProfileId()).add("DeploymentNumber", (Object)this.deploymentNumber()).add("ConfigurationName", (Object)this.configurationName()).add("ConfigurationLocationUri", (Object)this.configurationLocationUri()).add("ConfigurationVersion", (Object)this.configurationVersion()).add("Description", (Object)this.description()).add("DeploymentDurationInMinutes", (Object)this.deploymentDurationInMinutes()).add("GrowthType", (Object)this.growthTypeAsString()).add("GrowthFactor", (Object)this.growthFactor()).add("FinalBakeTimeInMinutes", (Object)this.finalBakeTimeInMinutes()).add("State", (Object)this.stateAsString()).add("EventLog", this.hasEventLog() ? this.eventLog() : null).add("PercentageComplete", (Object)this.percentageComplete()).add("StartedAt", (Object)this.startedAt()).add("CompletedAt", (Object)this.completedAt()).add("AppliedExtensions", this.hasAppliedExtensions() ? this.appliedExtensions() : null).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("KmsKeyIdentifier", (Object)this.kmsKeyIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "EnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "DeploymentStrategyId": {
                return Optional.ofNullable(clazz.cast(this.deploymentStrategyId()));
            }
            case "ConfigurationProfileId": {
                return Optional.ofNullable(clazz.cast(this.configurationProfileId()));
            }
            case "DeploymentNumber": {
                return Optional.ofNullable(clazz.cast(this.deploymentNumber()));
            }
            case "ConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.configurationName()));
            }
            case "ConfigurationLocationUri": {
                return Optional.ofNullable(clazz.cast(this.configurationLocationUri()));
            }
            case "ConfigurationVersion": {
                return Optional.ofNullable(clazz.cast(this.configurationVersion()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeploymentDurationInMinutes": {
                return Optional.ofNullable(clazz.cast(this.deploymentDurationInMinutes()));
            }
            case "GrowthType": {
                return Optional.ofNullable(clazz.cast(this.growthTypeAsString()));
            }
            case "GrowthFactor": {
                return Optional.ofNullable(clazz.cast(this.growthFactor()));
            }
            case "FinalBakeTimeInMinutes": {
                return Optional.ofNullable(clazz.cast(this.finalBakeTimeInMinutes()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "EventLog": {
                return Optional.ofNullable(clazz.cast(this.eventLog()));
            }
            case "PercentageComplete": {
                return Optional.ofNullable(clazz.cast(this.percentageComplete()));
            }
            case "StartedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "CompletedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
            case "AppliedExtensions": {
                return Optional.ofNullable(clazz.cast(this.appliedExtensions()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "KmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopDeploymentResponse, T> g) {
        return obj -> g.apply((StopDeploymentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String environmentId;
        private String deploymentStrategyId;
        private String configurationProfileId;
        private Integer deploymentNumber;
        private String configurationName;
        private String configurationLocationUri;
        private String configurationVersion;
        private String description;
        private Integer deploymentDurationInMinutes;
        private String growthType;
        private Float growthFactor;
        private Integer finalBakeTimeInMinutes;
        private String state;
        private List<DeploymentEvent> eventLog = DefaultSdkAutoConstructList.getInstance();
        private Float percentageComplete;
        private Instant startedAt;
        private Instant completedAt;
        private List<AppliedExtension> appliedExtensions = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyArn;
        private String kmsKeyIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(StopDeploymentResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.environmentId(model.environmentId);
            this.deploymentStrategyId(model.deploymentStrategyId);
            this.configurationProfileId(model.configurationProfileId);
            this.deploymentNumber(model.deploymentNumber);
            this.configurationName(model.configurationName);
            this.configurationLocationUri(model.configurationLocationUri);
            this.configurationVersion(model.configurationVersion);
            this.description(model.description);
            this.deploymentDurationInMinutes(model.deploymentDurationInMinutes);
            this.growthType(model.growthType);
            this.growthFactor(model.growthFactor);
            this.finalBakeTimeInMinutes(model.finalBakeTimeInMinutes);
            this.state(model.state);
            this.eventLog(model.eventLog);
            this.percentageComplete(model.percentageComplete);
            this.startedAt(model.startedAt);
            this.completedAt(model.completedAt);
            this.appliedExtensions(model.appliedExtensions);
            this.kmsKeyArn(model.kmsKeyArn);
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getDeploymentStrategyId() {
            return this.deploymentStrategyId;
        }

        public final void setDeploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
        }

        @Override
        public final Builder deploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
            return this;
        }

        public final String getConfigurationProfileId() {
            return this.configurationProfileId;
        }

        public final void setConfigurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
        }

        @Override
        public final Builder configurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        public final Integer getDeploymentNumber() {
            return this.deploymentNumber;
        }

        public final void setDeploymentNumber(Integer deploymentNumber) {
            this.deploymentNumber = deploymentNumber;
        }

        @Override
        public final Builder deploymentNumber(Integer deploymentNumber) {
            this.deploymentNumber = deploymentNumber;
            return this;
        }

        public final String getConfigurationName() {
            return this.configurationName;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final String getConfigurationLocationUri() {
            return this.configurationLocationUri;
        }

        public final void setConfigurationLocationUri(String configurationLocationUri) {
            this.configurationLocationUri = configurationLocationUri;
        }

        @Override
        public final Builder configurationLocationUri(String configurationLocationUri) {
            this.configurationLocationUri = configurationLocationUri;
            return this;
        }

        public final String getConfigurationVersion() {
            return this.configurationVersion;
        }

        public final void setConfigurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
        }

        @Override
        public final Builder configurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getDeploymentDurationInMinutes() {
            return this.deploymentDurationInMinutes;
        }

        public final void setDeploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
        }

        @Override
        public final Builder deploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
            return this;
        }

        public final String getGrowthType() {
            return this.growthType;
        }

        public final void setGrowthType(String growthType) {
            this.growthType = growthType;
        }

        @Override
        public final Builder growthType(String growthType) {
            this.growthType = growthType;
            return this;
        }

        @Override
        public final Builder growthType(GrowthType growthType) {
            this.growthType(growthType == null ? null : growthType.toString());
            return this;
        }

        public final Float getGrowthFactor() {
            return this.growthFactor;
        }

        public final void setGrowthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
        }

        @Override
        public final Builder growthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
            return this;
        }

        public final Integer getFinalBakeTimeInMinutes() {
            return this.finalBakeTimeInMinutes;
        }

        public final void setFinalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
        }

        @Override
        public final Builder finalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DeploymentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<DeploymentEvent.Builder> getEventLog() {
            List<DeploymentEvent.Builder> result = DeploymentEventsCopier.copyToBuilder(this.eventLog);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventLog(Collection<DeploymentEvent.BuilderImpl> eventLog) {
            this.eventLog = DeploymentEventsCopier.copyFromBuilder(eventLog);
        }

        @Override
        public final Builder eventLog(Collection<DeploymentEvent> eventLog) {
            this.eventLog = DeploymentEventsCopier.copy(eventLog);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventLog(DeploymentEvent ... eventLog) {
            this.eventLog(Arrays.asList(eventLog));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventLog(Consumer<DeploymentEvent.Builder> ... eventLog) {
            this.eventLog(Stream.of(eventLog).map(c -> (DeploymentEvent)((DeploymentEvent.Builder)DeploymentEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Float getPercentageComplete() {
            return this.percentageComplete;
        }

        public final void setPercentageComplete(Float percentageComplete) {
            this.percentageComplete = percentageComplete;
        }

        @Override
        public final Builder percentageComplete(Float percentageComplete) {
            this.percentageComplete = percentageComplete;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return this.completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final List<AppliedExtension.Builder> getAppliedExtensions() {
            List<AppliedExtension.Builder> result = AppliedExtensionsCopier.copyToBuilder(this.appliedExtensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppliedExtensions(Collection<AppliedExtension.BuilderImpl> appliedExtensions) {
            this.appliedExtensions = AppliedExtensionsCopier.copyFromBuilder(appliedExtensions);
        }

        @Override
        public final Builder appliedExtensions(Collection<AppliedExtension> appliedExtensions) {
            this.appliedExtensions = AppliedExtensionsCopier.copy(appliedExtensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appliedExtensions(AppliedExtension ... appliedExtensions) {
            this.appliedExtensions(Arrays.asList(appliedExtensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appliedExtensions(Consumer<AppliedExtension.Builder> ... appliedExtensions) {
            this.appliedExtensions(Stream.of(appliedExtensions).map(c -> (AppliedExtension)((AppliedExtension.Builder)AppliedExtension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        @Override
        public StopDeploymentResponse build() {
            return new StopDeploymentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopDeploymentResponse> {
        public Builder applicationId(String var1);

        public Builder environmentId(String var1);

        public Builder deploymentStrategyId(String var1);

        public Builder configurationProfileId(String var1);

        public Builder deploymentNumber(Integer var1);

        public Builder configurationName(String var1);

        public Builder configurationLocationUri(String var1);

        public Builder configurationVersion(String var1);

        public Builder description(String var1);

        public Builder deploymentDurationInMinutes(Integer var1);

        public Builder growthType(String var1);

        public Builder growthType(GrowthType var1);

        public Builder growthFactor(Float var1);

        public Builder finalBakeTimeInMinutes(Integer var1);

        public Builder state(String var1);

        public Builder state(DeploymentState var1);

        public Builder eventLog(Collection<DeploymentEvent> var1);

        public Builder eventLog(DeploymentEvent ... var1);

        public Builder eventLog(Consumer<DeploymentEvent.Builder> ... var1);

        public Builder percentageComplete(Float var1);

        public Builder startedAt(Instant var1);

        public Builder completedAt(Instant var1);

        public Builder appliedExtensions(Collection<AppliedExtension> var1);

        public Builder appliedExtensions(AppliedExtension ... var1);

        public Builder appliedExtensions(Consumer<AppliedExtension.Builder> ... var1);

        public Builder kmsKeyArn(String var1);

        public Builder kmsKeyIdentifier(String var1);
    }
}

