/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentEventType {
    PERCENTAGE_UPDATED("PERCENTAGE_UPDATED"),
    ROLLBACK_STARTED("ROLLBACK_STARTED"),
    ROLLBACK_COMPLETED("ROLLBACK_COMPLETED"),
    BAKE_TIME_STARTED("BAKE_TIME_STARTED"),
    DEPLOYMENT_STARTED("DEPLOYMENT_STARTED"),
    DEPLOYMENT_COMPLETED("DEPLOYMENT_COMPLETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentEventType> VALUE_MAP;
    private final String value;

    private DeploymentEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentEventType> knownValues() {
        EnumSet<DeploymentEventType> knownValues = EnumSet.allOf(DeploymentEventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentEventType.class, DeploymentEventType::toString);
    }
}

