/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayAsyncClient;
import software.amazon.awssdk.services.apigateway.model.Deployment;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse;

public class GetDeploymentsPublisher
implements SdkPublisher<GetDeploymentsResponse> {
    private final ApiGatewayAsyncClient client;
    private final GetDeploymentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetDeploymentsPublisher(ApiGatewayAsyncClient client, GetDeploymentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetDeploymentsPublisher(ApiGatewayAsyncClient client, GetDeploymentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetDeploymentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetDeploymentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Deployment> items() {
        Function<GetDeploymentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetDeploymentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetDeploymentsResponseFetcher
    implements AsyncPageFetcher<GetDeploymentsResponse> {
        private GetDeploymentsResponseFetcher() {
        }

        public boolean hasNextPage(GetDeploymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public CompletableFuture<GetDeploymentsResponse> nextPage(GetDeploymentsResponse previousPage) {
            if (previousPage == null) {
                return GetDeploymentsPublisher.this.client.getDeployments(GetDeploymentsPublisher.this.firstRequest);
            }
            return GetDeploymentsPublisher.this.client.getDeployments((GetDeploymentsRequest)((Object)GetDeploymentsPublisher.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

