/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayAsyncClient;
import software.amazon.awssdk.services.apigateway.model.GetRestApisRequest;
import software.amazon.awssdk.services.apigateway.model.GetRestApisResponse;
import software.amazon.awssdk.services.apigateway.model.RestApi;

public class GetRestApisPublisher
implements SdkPublisher<GetRestApisResponse> {
    private final ApiGatewayAsyncClient client;
    private final GetRestApisRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetRestApisPublisher(ApiGatewayAsyncClient client, GetRestApisRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetRestApisPublisher(ApiGatewayAsyncClient client, GetRestApisRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetRestApisResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetRestApisResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RestApi> items() {
        Function<GetRestApisResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetRestApisResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetRestApisResponseFetcher
    implements AsyncPageFetcher<GetRestApisResponse> {
        private GetRestApisResponseFetcher() {
        }

        public boolean hasNextPage(GetRestApisResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public CompletableFuture<GetRestApisResponse> nextPage(GetRestApisResponse previousPage) {
            if (previousPage == null) {
                return GetRestApisPublisher.this.client.getRestApis(GetRestApisPublisher.this.firstRequest);
            }
            return GetRestApisPublisher.this.client.getRestApis((GetRestApisRequest)((Object)GetRestApisPublisher.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

