/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBasePathMappingResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetBasePathMappingResponse> {
    private static final SdkField<String> BASE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("basePath").getter(GetBasePathMappingResponse.getter(GetBasePathMappingResponse::basePath)).setter(GetBasePathMappingResponse.setter(Builder::basePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basePath").build()}).build();
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("restApiId").getter(GetBasePathMappingResponse.getter(GetBasePathMappingResponse::restApiId)).setter(GetBasePathMappingResponse.setter(Builder::restApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restApiId").build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stage").getter(GetBasePathMappingResponse.getter(GetBasePathMappingResponse::stage)).setter(GetBasePathMappingResponse.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_PATH_FIELD, REST_API_ID_FIELD, STAGE_FIELD));
    private final String basePath;
    private final String restApiId;
    private final String stage;

    private GetBasePathMappingResponse(BuilderImpl builder) {
        super(builder);
        this.basePath = builder.basePath;
        this.restApiId = builder.restApiId;
        this.stage = builder.stage;
    }

    public final String basePath() {
        return this.basePath;
    }

    public final String restApiId() {
        return this.restApiId;
    }

    public final String stage() {
        return this.stage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.basePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBasePathMappingResponse)) {
            return false;
        }
        GetBasePathMappingResponse other = (GetBasePathMappingResponse)((Object)obj);
        return Objects.equals(this.basePath(), other.basePath()) && Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.stage(), other.stage());
    }

    public final String toString() {
        return ToString.builder((String)"GetBasePathMappingResponse").add("BasePath", (Object)this.basePath()).add("RestApiId", (Object)this.restApiId()).add("Stage", (Object)this.stage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "basePath": {
                return Optional.ofNullable(clazz.cast(this.basePath()));
            }
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "stage": {
                return Optional.ofNullable(clazz.cast(this.stage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBasePathMappingResponse, T> g) {
        return obj -> g.apply((GetBasePathMappingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String basePath;
        private String restApiId;
        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBasePathMappingResponse model) {
            super(model);
            this.basePath(model.basePath);
            this.restApiId(model.restApiId);
            this.stage(model.stage);
        }

        public final String getBasePath() {
            return this.basePath;
        }

        public final void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        @Override
        public final Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public GetBasePathMappingResponse build() {
            return new GetBasePathMappingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBasePathMappingResponse> {
        public Builder basePath(String var1);

        public Builder restApiId(String var1);

        public Builder stage(String var1);
    }
}

