/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amplifyuibuilder.AmplifyUiBuilderClient;
import software.amazon.awssdk.services.amplifyuibuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobSummary;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsResponse;

public class ListCodegenJobsIterable
implements SdkIterable<ListCodegenJobsResponse> {
    private final AmplifyUiBuilderClient client;
    private final ListCodegenJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCodegenJobsIterable(AmplifyUiBuilderClient client, ListCodegenJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCodegenJobsResponseFetcher();
    }

    public Iterator<ListCodegenJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CodegenJobSummary> entities() {
        Function<ListCodegenJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCodegenJobsResponseFetcher
    implements SyncPageFetcher<ListCodegenJobsResponse> {
        private ListCodegenJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListCodegenJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCodegenJobsResponse nextPage(ListCodegenJobsResponse previousPage) {
            if (previousPage == null) {
                return ListCodegenJobsIterable.this.client.listCodegenJobs(ListCodegenJobsIterable.this.firstRequest);
            }
            return ListCodegenJobsIterable.this.client.listCodegenJobs((ListCodegenJobsRequest)((Object)ListCodegenJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

