/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifybackend.model.AmplifyBackendRequest;
import software.amazon.awssdk.services.amplifybackend.model.BackendAPIResourceConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBackendApiRequest
extends AmplifyBackendRequest
implements ToCopyableBuilder<Builder, CreateBackendApiRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppId").getter(CreateBackendApiRequest.getter(CreateBackendApiRequest::appId)).setter(CreateBackendApiRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> BACKEND_ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackendEnvironmentName").getter(CreateBackendApiRequest.getter(CreateBackendApiRequest::backendEnvironmentName)).setter(CreateBackendApiRequest.setter(Builder::backendEnvironmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironmentName").build()}).build();
    private static final SdkField<BackendAPIResourceConfig> RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceConfig").getter(CreateBackendApiRequest.getter(CreateBackendApiRequest::resourceConfig)).setter(CreateBackendApiRequest.setter(Builder::resourceConfig)).constructor(BackendAPIResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfig").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(CreateBackendApiRequest.getter(CreateBackendApiRequest::resourceName)).setter(CreateBackendApiRequest.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, BACKEND_ENVIRONMENT_NAME_FIELD, RESOURCE_CONFIG_FIELD, RESOURCE_NAME_FIELD));
    private final String appId;
    private final String backendEnvironmentName;
    private final BackendAPIResourceConfig resourceConfig;
    private final String resourceName;

    private CreateBackendApiRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.backendEnvironmentName = builder.backendEnvironmentName;
        this.resourceConfig = builder.resourceConfig;
        this.resourceName = builder.resourceName;
    }

    public final String appId() {
        return this.appId;
    }

    public final String backendEnvironmentName() {
        return this.backendEnvironmentName;
    }

    public final BackendAPIResourceConfig resourceConfig() {
        return this.resourceConfig;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backendEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackendApiRequest)) {
            return false;
        }
        CreateBackendApiRequest other = (CreateBackendApiRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.backendEnvironmentName(), other.backendEnvironmentName()) && Objects.equals(this.resourceConfig(), other.resourceConfig()) && Objects.equals(this.resourceName(), other.resourceName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBackendApiRequest").add("AppId", (Object)this.appId()).add("BackendEnvironmentName", (Object)this.backendEnvironmentName()).add("ResourceConfig", (Object)this.resourceConfig()).add("ResourceName", (Object)this.resourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "BackendEnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.backendEnvironmentName()));
            }
            case "ResourceConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceConfig()));
            }
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackendApiRequest, T> g) {
        return obj -> g.apply((CreateBackendApiRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyBackendRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String backendEnvironmentName;
        private BackendAPIResourceConfig resourceConfig;
        private String resourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackendApiRequest model) {
            super(model);
            this.appId(model.appId);
            this.backendEnvironmentName(model.backendEnvironmentName);
            this.resourceConfig(model.resourceConfig);
            this.resourceName(model.resourceName);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getBackendEnvironmentName() {
            return this.backendEnvironmentName;
        }

        public final void setBackendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
        }

        @Override
        public final Builder backendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
            return this;
        }

        public final BackendAPIResourceConfig.Builder getResourceConfig() {
            return this.resourceConfig != null ? this.resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(BackendAPIResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        public final Builder resourceConfig(BackendAPIResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBackendApiRequest build() {
            return new CreateBackendApiRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyBackendRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBackendApiRequest> {
        public Builder appId(String var1);

        public Builder backendEnvironmentName(String var1);

        public Builder resourceConfig(BackendAPIResourceConfig var1);

        default public Builder resourceConfig(Consumer<BackendAPIResourceConfig.Builder> resourceConfig) {
            return this.resourceConfig((BackendAPIResourceConfig)((BackendAPIResourceConfig.Builder)BackendAPIResourceConfig.builder().applyMutation(resourceConfig)).build());
        }

        public Builder resourceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

