/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifybackend.model.ListOfMfaTypesElementCopier;
import software.amazon.awssdk.services.amplifybackend.model.MfaTypesElement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Settings> {
    private static final SdkField<List<String>> MFA_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MfaTypes").getter(Settings.getter(Settings::mfaTypesAsStrings)).setter(Settings.setter(Builder::mfaTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mfaTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SMS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SmsMessage").getter(Settings.getter(Settings::smsMessage)).setter(Settings.setter(Builder::smsMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smsMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MFA_TYPES_FIELD, SMS_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> mfaTypes;
    private final String smsMessage;

    private Settings(BuilderImpl builder) {
        this.mfaTypes = builder.mfaTypes;
        this.smsMessage = builder.smsMessage;
    }

    public final List<MfaTypesElement> mfaTypes() {
        return ListOfMfaTypesElementCopier.copyStringToEnum(this.mfaTypes);
    }

    public final boolean hasMfaTypes() {
        return this.mfaTypes != null && !(this.mfaTypes instanceof SdkAutoConstructList);
    }

    public final List<String> mfaTypesAsStrings() {
        return this.mfaTypes;
    }

    public final String smsMessage() {
        return this.smsMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMfaTypes() ? this.mfaTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.smsMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Settings)) {
            return false;
        }
        Settings other = (Settings)obj;
        return this.hasMfaTypes() == other.hasMfaTypes() && Objects.equals(this.mfaTypesAsStrings(), other.mfaTypesAsStrings()) && Objects.equals(this.smsMessage(), other.smsMessage());
    }

    public final String toString() {
        return ToString.builder((String)"Settings").add("MfaTypes", this.hasMfaTypes() ? this.mfaTypesAsStrings() : null).add("SmsMessage", (Object)this.smsMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MfaTypes": {
                return Optional.ofNullable(clazz.cast(this.mfaTypesAsStrings()));
            }
            case "SmsMessage": {
                return Optional.ofNullable(clazz.cast(this.smsMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Settings, T> g) {
        return obj -> g.apply((Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> mfaTypes = DefaultSdkAutoConstructList.getInstance();
        private String smsMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(Settings model) {
            this.mfaTypesWithStrings(model.mfaTypes);
            this.smsMessage(model.smsMessage);
        }

        public final Collection<String> getMfaTypes() {
            if (this.mfaTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.mfaTypes;
        }

        public final void setMfaTypes(Collection<String> mfaTypes) {
            this.mfaTypes = ListOfMfaTypesElementCopier.copy(mfaTypes);
        }

        @Override
        public final Builder mfaTypesWithStrings(Collection<String> mfaTypes) {
            this.mfaTypes = ListOfMfaTypesElementCopier.copy(mfaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaTypesWithStrings(String ... mfaTypes) {
            this.mfaTypesWithStrings(Arrays.asList(mfaTypes));
            return this;
        }

        @Override
        public final Builder mfaTypes(Collection<MfaTypesElement> mfaTypes) {
            this.mfaTypes = ListOfMfaTypesElementCopier.copyEnumToString(mfaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaTypes(MfaTypesElement ... mfaTypes) {
            this.mfaTypes(Arrays.asList(mfaTypes));
            return this;
        }

        public final String getSmsMessage() {
            return this.smsMessage;
        }

        public final void setSmsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
        }

        @Override
        public final Builder smsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public Settings build() {
            return new Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Settings> {
        public Builder mfaTypesWithStrings(Collection<String> var1);

        public Builder mfaTypesWithStrings(String ... var1);

        public Builder mfaTypes(Collection<MfaTypesElement> var1);

        public Builder mfaTypes(MfaTypesElement ... var1);

        public Builder smsMessage(String var1);
    }
}

