/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifybackend.model.AdditionalConstraintsElement;
import software.amazon.awssdk.services.amplifybackend.model.ListOfAdditionalConstraintsElementCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBackendAuthPasswordPolicyConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateBackendAuthPasswordPolicyConfig> {
    private static final SdkField<List<String>> ADDITIONAL_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalConstraints").getter(UpdateBackendAuthPasswordPolicyConfig.getter(UpdateBackendAuthPasswordPolicyConfig::additionalConstraintsAsStrings)).setter(UpdateBackendAuthPasswordPolicyConfig.setter(Builder::additionalConstraintsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> MINIMUM_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinimumLength").getter(UpdateBackendAuthPasswordPolicyConfig.getter(UpdateBackendAuthPasswordPolicyConfig::minimumLength)).setter(UpdateBackendAuthPasswordPolicyConfig.setter(Builder::minimumLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLength").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_CONSTRAINTS_FIELD, MINIMUM_LENGTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> additionalConstraints;
    private final Double minimumLength;

    private UpdateBackendAuthPasswordPolicyConfig(BuilderImpl builder) {
        this.additionalConstraints = builder.additionalConstraints;
        this.minimumLength = builder.minimumLength;
    }

    public final List<AdditionalConstraintsElement> additionalConstraints() {
        return ListOfAdditionalConstraintsElementCopier.copyStringToEnum(this.additionalConstraints);
    }

    public final boolean hasAdditionalConstraints() {
        return this.additionalConstraints != null && !(this.additionalConstraints instanceof SdkAutoConstructList);
    }

    public final List<String> additionalConstraintsAsStrings() {
        return this.additionalConstraints;
    }

    public final Double minimumLength() {
        return this.minimumLength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalConstraints() ? this.additionalConstraintsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumLength());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBackendAuthPasswordPolicyConfig)) {
            return false;
        }
        UpdateBackendAuthPasswordPolicyConfig other = (UpdateBackendAuthPasswordPolicyConfig)obj;
        return this.hasAdditionalConstraints() == other.hasAdditionalConstraints() && Objects.equals(this.additionalConstraintsAsStrings(), other.additionalConstraintsAsStrings()) && Objects.equals(this.minimumLength(), other.minimumLength());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBackendAuthPasswordPolicyConfig").add("AdditionalConstraints", this.hasAdditionalConstraints() ? this.additionalConstraintsAsStrings() : null).add("MinimumLength", (Object)this.minimumLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalConstraints": {
                return Optional.ofNullable(clazz.cast(this.additionalConstraintsAsStrings()));
            }
            case "MinimumLength": {
                return Optional.ofNullable(clazz.cast(this.minimumLength()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBackendAuthPasswordPolicyConfig, T> g) {
        return obj -> g.apply((UpdateBackendAuthPasswordPolicyConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> additionalConstraints = DefaultSdkAutoConstructList.getInstance();
        private Double minimumLength;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBackendAuthPasswordPolicyConfig model) {
            this.additionalConstraintsWithStrings(model.additionalConstraints);
            this.minimumLength(model.minimumLength);
        }

        public final Collection<String> getAdditionalConstraints() {
            if (this.additionalConstraints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalConstraints;
        }

        public final void setAdditionalConstraints(Collection<String> additionalConstraints) {
            this.additionalConstraints = ListOfAdditionalConstraintsElementCopier.copy(additionalConstraints);
        }

        @Override
        @Transient
        public final Builder additionalConstraintsWithStrings(Collection<String> additionalConstraints) {
            this.additionalConstraints = ListOfAdditionalConstraintsElementCopier.copy(additionalConstraints);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder additionalConstraintsWithStrings(String ... additionalConstraints) {
            this.additionalConstraintsWithStrings(Arrays.asList(additionalConstraints));
            return this;
        }

        @Override
        @Transient
        public final Builder additionalConstraints(Collection<AdditionalConstraintsElement> additionalConstraints) {
            this.additionalConstraints = ListOfAdditionalConstraintsElementCopier.copyEnumToString(additionalConstraints);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder additionalConstraints(AdditionalConstraintsElement ... additionalConstraints) {
            this.additionalConstraints(Arrays.asList(additionalConstraints));
            return this;
        }

        public final Double getMinimumLength() {
            return this.minimumLength;
        }

        public final void setMinimumLength(Double minimumLength) {
            this.minimumLength = minimumLength;
        }

        @Override
        @Transient
        public final Builder minimumLength(Double minimumLength) {
            this.minimumLength = minimumLength;
            return this;
        }

        public UpdateBackendAuthPasswordPolicyConfig build() {
            return new UpdateBackendAuthPasswordPolicyConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateBackendAuthPasswordPolicyConfig> {
        public Builder additionalConstraintsWithStrings(Collection<String> var1);

        public Builder additionalConstraintsWithStrings(String ... var1);

        public Builder additionalConstraints(Collection<AdditionalConstraintsElement> var1);

        public Builder additionalConstraints(AdditionalConstraintsElement ... var1);

        public Builder minimumLength(Double var1);
    }
}

