/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amp.AmpAsyncClient;
import software.amazon.awssdk.services.amp.internal.UserAgentUtils;
import software.amazon.awssdk.services.amp.model.ListRuleGroupsNamespacesRequest;
import software.amazon.awssdk.services.amp.model.ListRuleGroupsNamespacesResponse;
import software.amazon.awssdk.services.amp.model.RuleGroupsNamespaceSummary;

public class ListRuleGroupsNamespacesPublisher
implements SdkPublisher<ListRuleGroupsNamespacesResponse> {
    private final AmpAsyncClient client;
    private final ListRuleGroupsNamespacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRuleGroupsNamespacesPublisher(AmpAsyncClient client, ListRuleGroupsNamespacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRuleGroupsNamespacesPublisher(AmpAsyncClient client, ListRuleGroupsNamespacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRuleGroupsNamespacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRuleGroupsNamespacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RuleGroupsNamespaceSummary> ruleGroupsNamespaces() {
        Function<ListRuleGroupsNamespacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.ruleGroupsNamespaces() != null) {
                return response.ruleGroupsNamespaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRuleGroupsNamespacesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRuleGroupsNamespacesResponseFetcher
    implements AsyncPageFetcher<ListRuleGroupsNamespacesResponse> {
        private ListRuleGroupsNamespacesResponseFetcher() {
        }

        public boolean hasNextPage(ListRuleGroupsNamespacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRuleGroupsNamespacesResponse> nextPage(ListRuleGroupsNamespacesResponse previousPage) {
            if (previousPage == null) {
                return ListRuleGroupsNamespacesPublisher.this.client.listRuleGroupsNamespaces(ListRuleGroupsNamespacesPublisher.this.firstRequest);
            }
            return ListRuleGroupsNamespacesPublisher.this.client.listRuleGroupsNamespaces((ListRuleGroupsNamespacesRequest)((Object)ListRuleGroupsNamespacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

