/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amp.model.LoggingConfigurationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoggingConfigurationMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoggingConfigurationMetadata> {
    private static final SdkField<LoggingConfigurationStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(LoggingConfigurationMetadata.getter(LoggingConfigurationMetadata::status)).setter(LoggingConfigurationMetadata.setter(Builder::status)).constructor(LoggingConfigurationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> WORKSPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspace").getter(LoggingConfigurationMetadata.getter(LoggingConfigurationMetadata::workspace)).setter(LoggingConfigurationMetadata.setter(Builder::workspace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspace").build()}).build();
    private static final SdkField<String> LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupArn").getter(LoggingConfigurationMetadata.getter(LoggingConfigurationMetadata::logGroupArn)).setter(LoggingConfigurationMetadata.setter(Builder::logGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(LoggingConfigurationMetadata.getter(LoggingConfigurationMetadata::createdAt)).setter(LoggingConfigurationMetadata.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(LoggingConfigurationMetadata.getter(LoggingConfigurationMetadata::modifiedAt)).setter(LoggingConfigurationMetadata.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, WORKSPACE_FIELD, LOG_GROUP_ARN_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final LoggingConfigurationStatus status;
    private final String workspace;
    private final String logGroupArn;
    private final Instant createdAt;
    private final Instant modifiedAt;

    private LoggingConfigurationMetadata(BuilderImpl builder) {
        this.status = builder.status;
        this.workspace = builder.workspace;
        this.logGroupArn = builder.logGroupArn;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
    }

    public final LoggingConfigurationStatus status() {
        return this.status;
    }

    public final String workspace() {
        return this.workspace;
    }

    public final String logGroupArn() {
        return this.logGroupArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspace());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfigurationMetadata)) {
            return false;
        }
        LoggingConfigurationMetadata other = (LoggingConfigurationMetadata)obj;
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.workspace(), other.workspace()) && Objects.equals(this.logGroupArn(), other.logGroupArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt());
    }

    public final String toString() {
        return ToString.builder((String)"LoggingConfigurationMetadata").add("Status", (Object)this.status()).add("Workspace", (Object)this.workspace()).add("LogGroupArn", (Object)this.logGroupArn()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "workspace": {
                return Optional.ofNullable(clazz.cast(this.workspace()));
            }
            case "logGroupArn": {
                return Optional.ofNullable(clazz.cast(this.logGroupArn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfigurationMetadata, T> g) {
        return obj -> g.apply((LoggingConfigurationMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LoggingConfigurationStatus status;
        private String workspace;
        private String logGroupArn;
        private Instant createdAt;
        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfigurationMetadata model) {
            this.status(model.status);
            this.workspace(model.workspace);
            this.logGroupArn(model.logGroupArn);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
        }

        public final LoggingConfigurationStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(LoggingConfigurationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(LoggingConfigurationStatus status) {
            this.status = status;
            return this;
        }

        public final String getWorkspace() {
            return this.workspace;
        }

        public final void setWorkspace(String workspace) {
            this.workspace = workspace;
        }

        @Override
        public final Builder workspace(String workspace) {
            this.workspace = workspace;
            return this;
        }

        public final String getLogGroupArn() {
            return this.logGroupArn;
        }

        public final void setLogGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
        }

        @Override
        public final Builder logGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public LoggingConfigurationMetadata build() {
            return new LoggingConfigurationMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoggingConfigurationMetadata> {
        public Builder status(LoggingConfigurationStatus var1);

        default public Builder status(Consumer<LoggingConfigurationStatus.Builder> status) {
            return this.status((LoggingConfigurationStatus)((LoggingConfigurationStatus.Builder)LoggingConfigurationStatus.builder().applyMutation(status)).build());
        }

        public Builder workspace(String var1);

        public Builder logGroupArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);
    }
}

