/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.amp.AmpClient;
import software.amazon.awssdk.services.amp.AmpClientBuilder;
import software.amazon.awssdk.services.amp.AmpServiceClientConfiguration;
import software.amazon.awssdk.services.amp.DefaultAmpBaseClientBuilder;
import software.amazon.awssdk.services.amp.DefaultAmpClient;
import software.amazon.awssdk.services.amp.endpoints.AmpEndpointProvider;

@SdkInternalApi
final class DefaultAmpClientBuilder
extends DefaultAmpBaseClientBuilder<AmpClientBuilder, AmpClient>
implements AmpClientBuilder {
    DefaultAmpClientBuilder() {
    }

    @Override
    public DefaultAmpClientBuilder endpointProvider(AmpEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AmpClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAmpClientBuilder.validateClientOptions(clientConfiguration);
        AmpServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAmpClient client = new DefaultAmpClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AmpServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AmpServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

