/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.amp.AmpAsyncClient;
import software.amazon.awssdk.services.amp.AmpAsyncClientBuilder;
import software.amazon.awssdk.services.amp.AmpServiceClientConfiguration;
import software.amazon.awssdk.services.amp.DefaultAmpAsyncClient;
import software.amazon.awssdk.services.amp.DefaultAmpBaseClientBuilder;
import software.amazon.awssdk.services.amp.endpoints.AmpEndpointProvider;

@SdkInternalApi
final class DefaultAmpAsyncClientBuilder
extends DefaultAmpBaseClientBuilder<AmpAsyncClientBuilder, AmpAsyncClient>
implements AmpAsyncClientBuilder {
    DefaultAmpAsyncClientBuilder() {
    }

    @Override
    public DefaultAmpAsyncClientBuilder endpointProvider(AmpEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AmpAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAmpAsyncClientBuilder.validateClientOptions(clientConfiguration);
        AmpServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAmpAsyncClient client = new DefaultAmpAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AmpServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AmpServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

