/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceEventType {
    CONNECTION_STATUS("CONNECTION_STATUS"),
    DEVICE_STATUS("DEVICE_STATUS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceEventType> VALUE_MAP;
    private final String value;

    private DeviceEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceEventType> knownValues() {
        EnumSet<DeviceEventType> knownValues = EnumSet.allOf(DeviceEventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceEventType.class, DeviceEventType::toString);
    }
}

