/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BusinessReportFailureCode {
    ACCESS_DENIED("ACCESS_DENIED"),
    NO_SUCH_BUCKET("NO_SUCH_BUCKET"),
    INTERNAL_FAILURE("INTERNAL_FAILURE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BusinessReportFailureCode> VALUE_MAP;
    private final String value;

    private BusinessReportFailureCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BusinessReportFailureCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BusinessReportFailureCode> knownValues() {
        EnumSet<BusinessReportFailureCode> knownValues = EnumSet.allOf(BusinessReportFailureCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BusinessReportFailureCode.class, BusinessReportFailureCode::toString);
    }
}

