/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient;
import software.amazon.awssdk.services.alexaforbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse;

public class ListSmartHomeAppliancesPublisher
implements SdkPublisher<ListSmartHomeAppliancesResponse> {
    private final AlexaForBusinessAsyncClient client;
    private final ListSmartHomeAppliancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSmartHomeAppliancesPublisher(AlexaForBusinessAsyncClient client, ListSmartHomeAppliancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSmartHomeAppliancesPublisher(AlexaForBusinessAsyncClient client, ListSmartHomeAppliancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSmartHomeAppliancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSmartHomeAppliancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSmartHomeAppliancesResponseFetcher
    implements AsyncPageFetcher<ListSmartHomeAppliancesResponse> {
        private ListSmartHomeAppliancesResponseFetcher() {
        }

        public boolean hasNextPage(ListSmartHomeAppliancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSmartHomeAppliancesResponse> nextPage(ListSmartHomeAppliancesResponse previousPage) {
            if (previousPage == null) {
                return ListSmartHomeAppliancesPublisher.this.client.listSmartHomeAppliances(ListSmartHomeAppliancesPublisher.this.firstRequest);
            }
            return ListSmartHomeAppliancesPublisher.this.client.listSmartHomeAppliances((ListSmartHomeAppliancesRequest)((Object)ListSmartHomeAppliancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

