/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient;
import software.amazon.awssdk.services.alexaforbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse;

public class ListSkillsStoreCategoriesPublisher
implements SdkPublisher<ListSkillsStoreCategoriesResponse> {
    private final AlexaForBusinessAsyncClient client;
    private final ListSkillsStoreCategoriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSkillsStoreCategoriesPublisher(AlexaForBusinessAsyncClient client, ListSkillsStoreCategoriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSkillsStoreCategoriesPublisher(AlexaForBusinessAsyncClient client, ListSkillsStoreCategoriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSkillsStoreCategoriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSkillsStoreCategoriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSkillsStoreCategoriesResponseFetcher
    implements AsyncPageFetcher<ListSkillsStoreCategoriesResponse> {
        private ListSkillsStoreCategoriesResponseFetcher() {
        }

        public boolean hasNextPage(ListSkillsStoreCategoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSkillsStoreCategoriesResponse> nextPage(ListSkillsStoreCategoriesResponse previousPage) {
            if (previousPage == null) {
                return ListSkillsStoreCategoriesPublisher.this.client.listSkillsStoreCategories(ListSkillsStoreCategoriesPublisher.this.firstRequest);
            }
            return ListSkillsStoreCategoriesPublisher.this.client.listSkillsStoreCategories((ListSkillsStoreCategoriesRequest)((Object)ListSkillsStoreCategoriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

