/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.BusinessReport;
import software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportContentRange;
import software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFormat;
import software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportRecurrence;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BusinessReportSchedule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BusinessReportSchedule> {
    private static final SdkField<String> SCHEDULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleArn").getter(BusinessReportSchedule.getter(BusinessReportSchedule::scheduleArn)).setter(BusinessReportSchedule.setter(Builder::scheduleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleArn").build()}).build();
    private static final SdkField<String> SCHEDULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleName").getter(BusinessReportSchedule.getter(BusinessReportSchedule::scheduleName)).setter(BusinessReportSchedule.setter(Builder::scheduleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleName").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(BusinessReportSchedule.getter(BusinessReportSchedule::s3BucketName)).setter(BusinessReportSchedule.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3KeyPrefix").getter(BusinessReportSchedule.getter(BusinessReportSchedule::s3KeyPrefix)).setter(BusinessReportSchedule.setter(Builder::s3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(BusinessReportSchedule.getter(BusinessReportSchedule::formatAsString)).setter(BusinessReportSchedule.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<BusinessReportContentRange> CONTENT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContentRange").getter(BusinessReportSchedule.getter(BusinessReportSchedule::contentRange)).setter(BusinessReportSchedule.setter(Builder::contentRange)).constructor(BusinessReportContentRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRange").build()}).build();
    private static final SdkField<BusinessReportRecurrence> RECURRENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Recurrence").getter(BusinessReportSchedule.getter(BusinessReportSchedule::recurrence)).setter(BusinessReportSchedule.setter(Builder::recurrence)).constructor(BusinessReportRecurrence::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").build()}).build();
    private static final SdkField<BusinessReport> LAST_BUSINESS_REPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastBusinessReport").getter(BusinessReportSchedule.getter(BusinessReportSchedule::lastBusinessReport)).setter(BusinessReportSchedule.setter(Builder::lastBusinessReport)).constructor(BusinessReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastBusinessReport").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_ARN_FIELD, SCHEDULE_NAME_FIELD, S3_BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD, FORMAT_FIELD, CONTENT_RANGE_FIELD, RECURRENCE_FIELD, LAST_BUSINESS_REPORT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String scheduleArn;
    private final String scheduleName;
    private final String s3BucketName;
    private final String s3KeyPrefix;
    private final String format;
    private final BusinessReportContentRange contentRange;
    private final BusinessReportRecurrence recurrence;
    private final BusinessReport lastBusinessReport;

    private BusinessReportSchedule(BuilderImpl builder) {
        this.scheduleArn = builder.scheduleArn;
        this.scheduleName = builder.scheduleName;
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.format = builder.format;
        this.contentRange = builder.contentRange;
        this.recurrence = builder.recurrence;
        this.lastBusinessReport = builder.lastBusinessReport;
    }

    public final String scheduleArn() {
        return this.scheduleArn;
    }

    public final String scheduleName() {
        return this.scheduleName;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public final BusinessReportFormat format() {
        return BusinessReportFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final BusinessReportContentRange contentRange() {
        return this.contentRange;
    }

    public final BusinessReportRecurrence recurrence() {
        return this.recurrence;
    }

    public final BusinessReport lastBusinessReport() {
        return this.lastBusinessReport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastBusinessReport());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BusinessReportSchedule)) {
            return false;
        }
        BusinessReportSchedule other = (BusinessReportSchedule)obj;
        return Objects.equals(this.scheduleArn(), other.scheduleArn()) && Objects.equals(this.scheduleName(), other.scheduleName()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3KeyPrefix(), other.s3KeyPrefix()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.contentRange(), other.contentRange()) && Objects.equals(this.recurrence(), other.recurrence()) && Objects.equals(this.lastBusinessReport(), other.lastBusinessReport());
    }

    public final String toString() {
        return ToString.builder((String)"BusinessReportSchedule").add("ScheduleArn", (Object)this.scheduleArn()).add("ScheduleName", (Object)this.scheduleName()).add("S3BucketName", (Object)this.s3BucketName()).add("S3KeyPrefix", (Object)this.s3KeyPrefix()).add("Format", (Object)this.formatAsString()).add("ContentRange", (Object)this.contentRange()).add("Recurrence", (Object)this.recurrence()).add("LastBusinessReport", (Object)this.lastBusinessReport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduleArn": {
                return Optional.ofNullable(clazz.cast(this.scheduleArn()));
            }
            case "ScheduleName": {
                return Optional.ofNullable(clazz.cast(this.scheduleName()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "S3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3KeyPrefix()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "ContentRange": {
                return Optional.ofNullable(clazz.cast(this.contentRange()));
            }
            case "Recurrence": {
                return Optional.ofNullable(clazz.cast(this.recurrence()));
            }
            case "LastBusinessReport": {
                return Optional.ofNullable(clazz.cast(this.lastBusinessReport()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BusinessReportSchedule, T> g) {
        return obj -> g.apply((BusinessReportSchedule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scheduleArn;
        private String scheduleName;
        private String s3BucketName;
        private String s3KeyPrefix;
        private String format;
        private BusinessReportContentRange contentRange;
        private BusinessReportRecurrence recurrence;
        private BusinessReport lastBusinessReport;

        private BuilderImpl() {
        }

        private BuilderImpl(BusinessReportSchedule model) {
            this.scheduleArn(model.scheduleArn);
            this.scheduleName(model.scheduleName);
            this.s3BucketName(model.s3BucketName);
            this.s3KeyPrefix(model.s3KeyPrefix);
            this.format(model.format);
            this.contentRange(model.contentRange);
            this.recurrence(model.recurrence);
            this.lastBusinessReport(model.lastBusinessReport);
        }

        public final String getScheduleArn() {
            return this.scheduleArn;
        }

        public final void setScheduleArn(String scheduleArn) {
            this.scheduleArn = scheduleArn;
        }

        @Override
        public final Builder scheduleArn(String scheduleArn) {
            this.scheduleArn = scheduleArn;
            return this;
        }

        public final String getScheduleName() {
            return this.scheduleName;
        }

        public final void setScheduleName(String scheduleName) {
            this.scheduleName = scheduleName;
        }

        @Override
        public final Builder scheduleName(String scheduleName) {
            this.scheduleName = scheduleName;
            return this;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(BusinessReportFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final BusinessReportContentRange.Builder getContentRange() {
            return this.contentRange != null ? this.contentRange.toBuilder() : null;
        }

        public final void setContentRange(BusinessReportContentRange.BuilderImpl contentRange) {
            this.contentRange = contentRange != null ? contentRange.build() : null;
        }

        @Override
        public final Builder contentRange(BusinessReportContentRange contentRange) {
            this.contentRange = contentRange;
            return this;
        }

        public final BusinessReportRecurrence.Builder getRecurrence() {
            return this.recurrence != null ? this.recurrence.toBuilder() : null;
        }

        public final void setRecurrence(BusinessReportRecurrence.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        @Override
        public final Builder recurrence(BusinessReportRecurrence recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final BusinessReport.Builder getLastBusinessReport() {
            return this.lastBusinessReport != null ? this.lastBusinessReport.toBuilder() : null;
        }

        public final void setLastBusinessReport(BusinessReport.BuilderImpl lastBusinessReport) {
            this.lastBusinessReport = lastBusinessReport != null ? lastBusinessReport.build() : null;
        }

        @Override
        public final Builder lastBusinessReport(BusinessReport lastBusinessReport) {
            this.lastBusinessReport = lastBusinessReport;
            return this;
        }

        public BusinessReportSchedule build() {
            return new BusinessReportSchedule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BusinessReportSchedule> {
        public Builder scheduleArn(String var1);

        public Builder scheduleName(String var1);

        public Builder s3BucketName(String var1);

        public Builder s3KeyPrefix(String var1);

        public Builder format(String var1);

        public Builder format(BusinessReportFormat var1);

        public Builder contentRange(BusinessReportContentRange var1);

        default public Builder contentRange(Consumer<BusinessReportContentRange.Builder> contentRange) {
            return this.contentRange((BusinessReportContentRange)((BusinessReportContentRange.Builder)BusinessReportContentRange.builder().applyMutation(contentRange)).build());
        }

        public Builder recurrence(BusinessReportRecurrence var1);

        default public Builder recurrence(Consumer<BusinessReportRecurrence.Builder> recurrence) {
            return this.recurrence((BusinessReportRecurrence)((BusinessReportRecurrence.Builder)BusinessReportRecurrence.builder().applyMutation(recurrence)).build());
        }

        public Builder lastBusinessReport(BusinessReport var1);

        default public Builder lastBusinessReport(Consumer<BusinessReport.Builder> lastBusinessReport) {
            return this.lastBusinessReport((BusinessReport)((BusinessReport.Builder)BusinessReport.builder().applyMutation(lastBusinessReport)).build());
        }
    }
}

