/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the type and format of extension access. Only one of <code>CustomObjectIdentifier</code> or
 * <code>AccessMethodType</code> may be provided. Providing both results in <code>InvalidArgsException</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessMethod implements SdkPojo, Serializable, ToCopyableBuilder<AccessMethod.Builder, AccessMethod> {
    private static final SdkField<String> CUSTOM_OBJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomObjectIdentifier").getter(getter(AccessMethod::customObjectIdentifier))
            .setter(setter(Builder::customObjectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomObjectIdentifier").build())
            .build();

    private static final SdkField<String> ACCESS_METHOD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessMethodType").getter(getter(AccessMethod::accessMethodTypeAsString))
            .setter(setter(Builder::accessMethodType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessMethodType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_OBJECT_IDENTIFIER_FIELD, ACCESS_METHOD_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String customObjectIdentifier;

    private final String accessMethodType;

    private AccessMethod(BuilderImpl builder) {
        this.customObjectIdentifier = builder.customObjectIdentifier;
        this.accessMethodType = builder.accessMethodType;
    }

    /**
     * <p>
     * An object identifier (OID) specifying the <code>AccessMethod</code>. The OID must satisfy the regular expression
     * shown below. For more information, see NIST's definition of <a
     * href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
     * </p>
     * 
     * @return An object identifier (OID) specifying the <code>AccessMethod</code>. The OID must satisfy the regular
     *         expression shown below. For more information, see NIST's definition of <a
     *         href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
     */
    public final String customObjectIdentifier() {
        return customObjectIdentifier;
    }

    /**
     * <p>
     * Specifies the <code>AccessMethod</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessMethodType}
     * will return {@link AccessMethodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accessMethodTypeAsString}.
     * </p>
     * 
     * @return Specifies the <code>AccessMethod</code>.
     * @see AccessMethodType
     */
    public final AccessMethodType accessMethodType() {
        return AccessMethodType.fromValue(accessMethodType);
    }

    /**
     * <p>
     * Specifies the <code>AccessMethod</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessMethodType}
     * will return {@link AccessMethodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accessMethodTypeAsString}.
     * </p>
     * 
     * @return Specifies the <code>AccessMethod</code>.
     * @see AccessMethodType
     */
    public final String accessMethodTypeAsString() {
        return accessMethodType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customObjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(accessMethodTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessMethod)) {
            return false;
        }
        AccessMethod other = (AccessMethod) obj;
        return Objects.equals(customObjectIdentifier(), other.customObjectIdentifier())
                && Objects.equals(accessMethodTypeAsString(), other.accessMethodTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessMethod").add("CustomObjectIdentifier", customObjectIdentifier())
                .add("AccessMethodType", accessMethodTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomObjectIdentifier":
            return Optional.ofNullable(clazz.cast(customObjectIdentifier()));
        case "AccessMethodType":
            return Optional.ofNullable(clazz.cast(accessMethodTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessMethod, T> g) {
        return obj -> g.apply((AccessMethod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessMethod> {
        /**
         * <p>
         * An object identifier (OID) specifying the <code>AccessMethod</code>. The OID must satisfy the regular
         * expression shown below. For more information, see NIST's definition of <a
         * href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
         * </p>
         * 
         * @param customObjectIdentifier
         *        An object identifier (OID) specifying the <code>AccessMethod</code>. The OID must satisfy the regular
         *        expression shown below. For more information, see NIST's definition of <a
         *        href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customObjectIdentifier(String customObjectIdentifier);

        /**
         * <p>
         * Specifies the <code>AccessMethod</code>.
         * </p>
         * 
         * @param accessMethodType
         *        Specifies the <code>AccessMethod</code>.
         * @see AccessMethodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessMethodType
         */
        Builder accessMethodType(String accessMethodType);

        /**
         * <p>
         * Specifies the <code>AccessMethod</code>.
         * </p>
         * 
         * @param accessMethodType
         *        Specifies the <code>AccessMethod</code>.
         * @see AccessMethodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessMethodType
         */
        Builder accessMethodType(AccessMethodType accessMethodType);
    }

    static final class BuilderImpl implements Builder {
        private String customObjectIdentifier;

        private String accessMethodType;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessMethod model) {
            customObjectIdentifier(model.customObjectIdentifier);
            accessMethodType(model.accessMethodType);
        }

        public final String getCustomObjectIdentifier() {
            return customObjectIdentifier;
        }

        public final void setCustomObjectIdentifier(String customObjectIdentifier) {
            this.customObjectIdentifier = customObjectIdentifier;
        }

        @Override
        public final Builder customObjectIdentifier(String customObjectIdentifier) {
            this.customObjectIdentifier = customObjectIdentifier;
            return this;
        }

        public final String getAccessMethodType() {
            return accessMethodType;
        }

        public final void setAccessMethodType(String accessMethodType) {
            this.accessMethodType = accessMethodType;
        }

        @Override
        public final Builder accessMethodType(String accessMethodType) {
            this.accessMethodType = accessMethodType;
            return this;
        }

        @Override
        public final Builder accessMethodType(AccessMethodType accessMethodType) {
            this.accessMethodType(accessMethodType == null ? null : accessMethodType.toString());
            return this;
        }

        @Override
        public AccessMethod build() {
            return new AccessMethod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
