/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acmpca.model.AccessMethod;
import software.amazon.awssdk.services.acmpca.model.GeneralName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessDescription> {
    private static final SdkField<AccessMethod> ACCESS_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessMethod").getter(AccessDescription.getter(AccessDescription::accessMethod)).setter(AccessDescription.setter(Builder::accessMethod)).constructor(AccessMethod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessMethod").build()}).build();
    private static final SdkField<GeneralName> ACCESS_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessLocation").getter(AccessDescription.getter(AccessDescription::accessLocation)).setter(AccessDescription.setter(Builder::accessLocation)).constructor(GeneralName::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_METHOD_FIELD, ACCESS_LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final AccessMethod accessMethod;
    private final GeneralName accessLocation;

    private AccessDescription(BuilderImpl builder) {
        this.accessMethod = builder.accessMethod;
        this.accessLocation = builder.accessLocation;
    }

    public final AccessMethod accessMethod() {
        return this.accessMethod;
    }

    public final GeneralName accessLocation() {
        return this.accessLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessDescription)) {
            return false;
        }
        AccessDescription other = (AccessDescription)obj;
        return Objects.equals(this.accessMethod(), other.accessMethod()) && Objects.equals(this.accessLocation(), other.accessLocation());
    }

    public final String toString() {
        return ToString.builder((String)"AccessDescription").add("AccessMethod", (Object)this.accessMethod()).add("AccessLocation", (Object)this.accessLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessMethod": {
                return Optional.ofNullable(clazz.cast(this.accessMethod()));
            }
            case "AccessLocation": {
                return Optional.ofNullable(clazz.cast(this.accessLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessDescription, T> g) {
        return obj -> g.apply((AccessDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AccessMethod accessMethod;
        private GeneralName accessLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessDescription model) {
            this.accessMethod(model.accessMethod);
            this.accessLocation(model.accessLocation);
        }

        public final AccessMethod.Builder getAccessMethod() {
            return this.accessMethod != null ? this.accessMethod.toBuilder() : null;
        }

        public final void setAccessMethod(AccessMethod.BuilderImpl accessMethod) {
            this.accessMethod = accessMethod != null ? accessMethod.build() : null;
        }

        @Override
        public final Builder accessMethod(AccessMethod accessMethod) {
            this.accessMethod = accessMethod;
            return this;
        }

        public final GeneralName.Builder getAccessLocation() {
            return this.accessLocation != null ? this.accessLocation.toBuilder() : null;
        }

        public final void setAccessLocation(GeneralName.BuilderImpl accessLocation) {
            this.accessLocation = accessLocation != null ? accessLocation.build() : null;
        }

        @Override
        public final Builder accessLocation(GeneralName accessLocation) {
            this.accessLocation = accessLocation;
            return this;
        }

        public AccessDescription build() {
            return new AccessDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessDescription> {
        public Builder accessMethod(AccessMethod var1);

        default public Builder accessMethod(Consumer<AccessMethod.Builder> accessMethod) {
            return this.accessMethod((AccessMethod)((AccessMethod.Builder)AccessMethod.builder().applyMutation(accessMethod)).build());
        }

        public Builder accessLocation(GeneralName var1);

        default public Builder accessLocation(Consumer<GeneralName.Builder> accessLocation) {
            return this.accessLocation((GeneralName)((GeneralName.Builder)GeneralName.builder().applyMutation(accessLocation)).build());
        }
    }
}

