/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RegionOptStatus {
    ENABLED("ENABLED"),
    ENABLING("ENABLING"),
    DISABLING("DISABLING"),
    DISABLED("DISABLED"),
    ENABLED_BY_DEFAULT("ENABLED_BY_DEFAULT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RegionOptStatus> VALUE_MAP;
    private final String value;

    private RegionOptStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RegionOptStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RegionOptStatus> knownValues() {
        EnumSet<RegionOptStatus> knownValues = EnumSet.allOf(RegionOptStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RegionOptStatus.class, RegionOptStatus::toString);
    }
}

