/*
 * Decompiled with CFR 0.152.
 */
package se.vgregion.pubsub.admin.service;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import se.vgregion.dao.domain.patterns.entity.Entity;
import se.vgregion.pubsub.admin.service.AdminService;
import se.vgregion.pubsub.push.FailedSubscriberVerificationException;
import se.vgregion.pubsub.push.PolledPublisher;
import se.vgregion.pubsub.push.PushSubscriber;
import se.vgregion.pubsub.push.impl.DefaultPolledPublisher;
import se.vgregion.pubsub.push.impl.PushSubscriberManager;
import se.vgregion.pubsub.push.repository.PolledPublisherRepository;
import se.vgregion.pubsub.push.repository.PushSubscriberRepository;

@Service
public class DefaultAdminService
implements AdminService {
    @Resource
    private PushSubscriberRepository subscriberRepository;
    @Resource
    private PushSubscriberManager pushSubscriberManager;
    @Resource
    private PolledPublisherRepository polledPublisherRepository;

    @Override
    @Transactional
    public void createPushSubscriber(URI uRI, URI uRI2, int n, String string, String string2, boolean bl) throws IOException, FailedSubscriberVerificationException {
        this.pushSubscriberManager.subscribe(uRI, uRI2, n, string, string2, bl, false);
    }

    @Override
    @Transactional
    public void updatePushSubscriber(UUID uUID, URI uRI, URI uRI2, int n, String string, String string2, boolean bl) throws IOException, FailedSubscriberVerificationException {
        this.removePushSubscriber(uUID);
        this.createPushSubscriber(uRI, uRI2, n, string, string2, bl);
    }

    @Override
    @Transactional
    public void removePushSubscriber(UUID uUID) {
        PushSubscriber pushSubscriber = (PushSubscriber)this.subscriberRepository.find((Object)uUID);
        if (pushSubscriber != null) {
            this.pushSubscriberManager.unsubscribe(pushSubscriber.getTopic(), pushSubscriber.getCallback(), false);
        }
    }

    @Override
    @Transactional
    public Collection<PushSubscriber> getAllPushSubscribers() {
        return this.subscriberRepository.findAll();
    }

    @Override
    @Transactional
    public PushSubscriber getPushSubscriber(UUID uUID) {
        return (PushSubscriber)this.subscriberRepository.find((Object)uUID);
    }

    @Override
    @Transactional
    public Collection<PolledPublisher> getAllPolledPublishers() {
        return this.polledPublisherRepository.findAll();
    }

    @Override
    @Transactional
    public void createPolledPublishers(URI uRI) throws IOException {
        this.polledPublisherRepository.persist((Entity)new DefaultPolledPublisher(uRI));
    }

    @Override
    @Transactional
    public PolledPublisher getPolledPublishers(UUID uUID) {
        return (PolledPublisher)this.polledPublisherRepository.find((Object)uUID);
    }

    @Override
    @Transactional
    public void updatePolledPublishers(UUID uUID, URI uRI) throws IOException {
        PolledPublisher polledPublisher = this.getPolledPublishers(uUID);
        if (polledPublisher == null) {
            throw new RuntimeException("Unknown publisher: " + uUID);
        }
        polledPublisher.setUrl(uRI);
    }

    @Override
    @Transactional
    public void removePolledPublishers(UUID uUID) {
        this.polledPublisherRepository.remove((Object)uUID);
    }

    public PushSubscriberRepository getSubscriberRepository() {
        return this.subscriberRepository;
    }

    public void setSubscriberRepository(PushSubscriberRepository pushSubscriberRepository) {
        this.subscriberRepository = pushSubscriberRepository;
    }

    public PushSubscriberManager getPushSubscriberManager() {
        return this.pushSubscriberManager;
    }

    public void setPushSubscriberManager(PushSubscriberManager pushSubscriberManager) {
        this.pushSubscriberManager = pushSubscriberManager;
    }

    public PolledPublisherRepository getPolledPublisherRepository() {
        return this.polledPublisherRepository;
    }

    public void setPolledPublisherRepository(PolledPublisherRepository polledPublisherRepository) {
        this.polledPublisherRepository = polledPublisherRepository;
    }
}

