/*
 * Decompiled with CFR 0.152.
 */
package se.vgregion.pubsub.admin.controller;

import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import se.vgregion.pubsub.admin.service.AdminService;
import se.vgregion.pubsub.push.FailedSubscriberVerificationException;
import se.vgregion.pubsub.push.PolledPublisher;
import se.vgregion.pubsub.push.PushSubscriber;

@Controller
public class AdminController {
    @Resource
    private AdminService adminService;

    @RequestMapping(value={"/admin"})
    public ModelAndView index() {
        ModelAndView modelAndView = new ModelAndView("admin/index");
        modelAndView.addObject("pushSubscribers", this.adminService.getAllPushSubscribers());
        modelAndView.addObject("polledPublishers", this.adminService.getAllPolledPublishers());
        return modelAndView;
    }

    @RequestMapping(value={"/admin/push/new"})
    public ModelAndView newPushSubscriber() {
        ModelAndView modelAndView = new ModelAndView("admin/push-edit");
        return modelAndView;
    }

    @RequestMapping(value={"/admin/push/{id}/edit"})
    public ModelAndView editPushSubscriber(@PathVariable(value="id") UUID uUID) {
        PushSubscriber pushSubscriber = this.adminService.getPushSubscriber(uUID);
        if (pushSubscriber != null) {
            ModelAndView modelAndView = new ModelAndView("admin/push-edit");
            modelAndView.addObject("subscriber", (Object)pushSubscriber);
            return modelAndView;
        }
        throw new RuntimeException("Unknown subscriber");
    }

    @RequestMapping(value={"/admin/push/new"}, method={RequestMethod.POST})
    public ModelAndView createPushSubscriber(@RequestParam(value="topic") URI uRI, @RequestParam(value="callback") URI uRI2, @RequestParam(value="leaseSeconds", required=false) Integer n, @RequestParam(value="verifyToken", required=false) String string, @RequestParam(value="secret", required=false) String string2, @RequestParam(value="active", defaultValue="false", required=false) Boolean bl) throws IOException, FailedSubscriberVerificationException {
        if (n == null) {
            n = 0;
        }
        this.adminService.createPushSubscriber(uRI, uRI2, n, string, string2, bl);
        return new ModelAndView("redirect:..");
    }

    @RequestMapping(value={"/admin/push/{id}/edit"}, method={RequestMethod.POST})
    public ModelAndView updatePushSubscriber(@RequestParam(value="id") UUID uUID, @RequestParam(value="topic") URI uRI, @RequestParam(value="callback") URI uRI2, @RequestParam(value="leaseSeconds", required=false) Integer n, @RequestParam(value="verifyToken", required=false) String string, @RequestParam(value="secret", required=false) String string2, @RequestParam(value="active", defaultValue="false", required=false) Boolean bl, @RequestParam(value="delete", required=false) String string3) throws IOException, FailedSubscriberVerificationException {
        if (n == null) {
            n = 0;
        }
        if (string3 != null) {
            this.adminService.removePushSubscriber(uUID);
        } else {
            this.adminService.updatePushSubscriber(uUID, uRI, uRI2, n, string, string2, bl);
        }
        return new ModelAndView("redirect:../..");
    }

    @RequestMapping(value={"/admin/polled/new"})
    public ModelAndView newPolledPublisher() {
        ModelAndView modelAndView = new ModelAndView("admin/polled-edit");
        return modelAndView;
    }

    @RequestMapping(value={"/admin/polled/{id}/edit"})
    public ModelAndView editPolledPublisher(@PathVariable(value="id") UUID uUID) {
        PolledPublisher polledPublisher = this.adminService.getPolledPublishers(uUID);
        if (polledPublisher != null) {
            ModelAndView modelAndView = new ModelAndView("admin/polled-edit");
            modelAndView.addObject("publisher", (Object)polledPublisher);
            return modelAndView;
        }
        throw new RuntimeException("Unknown publisher");
    }

    @RequestMapping(value={"/admin/polled/new"}, method={RequestMethod.POST})
    public ModelAndView createPolledPublisher(@RequestParam(value="url") URI uRI) throws IOException, FailedSubscriberVerificationException {
        this.adminService.createPolledPublishers(uRI);
        return new ModelAndView("redirect:..");
    }

    @RequestMapping(value={"/admin/polled/{id}/edit"}, method={RequestMethod.POST})
    public ModelAndView updatePolledPublisher(@RequestParam(value="id") UUID uUID, @RequestParam(value="url") URI uRI, @RequestParam(value="delete", required=false) String string) throws IOException, FailedSubscriberVerificationException {
        if (string != null) {
            this.adminService.removePolledPublishers(uUID);
        } else {
            this.adminService.updatePolledPublishers(uUID, uRI);
        }
        return new ModelAndView("redirect:../..");
    }

    public AdminService getAdminService() {
        return this.adminService;
    }

    public void setAdminService(AdminService adminService) {
        this.adminService = adminService;
    }
}

