/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.semantic;

import java.io.Serializable;
import java.util.Optional;
import se.bjurr.gitchangelog.internal.semantic.SemanticVersioning;

public class SemanticVersion
implements Serializable {
    private static final long serialVersionUID = -7875655375353325189L;
    private final int patch;
    private final int minor;
    private final int major;
    private String tag;
    private final SemanticVersioning.VERSION_STEP versionStep;

    public SemanticVersion(int major, int minor, int patch, SemanticVersioning.VERSION_STEP versionStep) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.versionStep = versionStep;
    }

    public SemanticVersion(int major, int minor, int patch) {
        this(major, minor, patch, SemanticVersioning.VERSION_STEP.NONE);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Optional<String> findTag() {
        return Optional.ofNullable(this.tag);
    }

    public SemanticVersioning.VERSION_STEP getVersionStep() {
        return this.versionStep;
    }

    public String getVersion() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }
}

