/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.jira;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;
import se.bjurr.gitchangelog.internal.integrations.jira.JiraIssue;

public abstract class JiraClient {
    private static final String ISSUE_API = "/issue/";
    private static final String ISSUE_API_FIELD_PREFIX = "$.fields.";
    private static final String COMMA = ",";
    private static final String QUESTION_MARK = "?";
    private static final String EMPTY_STRING = "";
    private static final String DEFAULT_FIELDS = "fields=parent,summary,issuetype,labels,description,issuelinks";
    private static final String BASE_PATH = "/rest/api/2";
    private static final Logger LOG = LoggerFactory.getLogger(JiraClient.class);
    private final String api;
    private List<String> fields = Collections.unmodifiableList(new ArrayList());

    public JiraClient(String api) {
        this.api = api.endsWith("/") ? api.substring(0, api.length() - 1) : api;
    }

    public String getApi() {
        return this.api;
    }

    protected String getIssuePath() {
        return ISSUE_API;
    }

    protected String getEndpoint(String issue) {
        return this.api + BASE_PATH + this.getIssuePath() + issue + "?fields=parent,summary,issuetype,labels,description,issuelinks" + (String)(this.hasIssueAdditionalFields() ? COMMA + this.getIssueAdditionalFieldsQuery() : EMPTY_STRING);
    }

    public JiraClient withIssueAdditionalFields(List<String> fields) {
        ArrayList<String> newFields = new ArrayList<String>(fields);
        Collections.sort(newFields);
        this.fields = Collections.unmodifiableList(newFields);
        return this;
    }

    private boolean hasIssueAdditionalFields() {
        return this.fields != null && !this.fields.isEmpty();
    }

    private String getIssueAdditionalFieldsQuery() {
        return String.join((CharSequence)COMMA, this.fields);
    }

    private String getFieldPrefix() {
        return ISSUE_API_FIELD_PREFIX;
    }

    protected JiraIssue toJiraIssue(String issue, String json) {
        String fieldPrefix = this.getFieldPrefix();
        String title = (String)JsonPath.read((String)json, (String)(fieldPrefix + "summary"), (Predicate[])new Predicate[0]);
        String description = (String)JsonPath.read((String)json, (String)(fieldPrefix + "description"), (Predicate[])new Predicate[0]);
        String type = (String)JsonPath.read((String)json, (String)(fieldPrefix + "issuetype.name"), (Predicate[])new Predicate[0]);
        String link = this.api + "/browse/" + issue;
        List labels = (List)JsonPath.read((String)json, (String)(fieldPrefix + "labels"), (Predicate[])new Predicate[0]);
        ArrayList<String> linkedIssues = new ArrayList<String>();
        List inwardKey = (List)JsonPath.read((String)json, (String)(fieldPrefix + "issuelinks[*].inwardIssue.key"), (Predicate[])new Predicate[0]);
        List outwardKey = (List)JsonPath.read((String)json, (String)(fieldPrefix + "issuelinks[*].outwardIssue.key"), (Predicate[])new Predicate[0]);
        linkedIssues.addAll(inwardKey);
        linkedIssues.addAll(outwardKey);
        Map additionalFields = this.fields.stream().reduce(new TreeMap(), (fields, field) -> this.getAdditionalField(json, fieldPrefix, (Map<String, Object>)fields, (String)field), (leftSide, rightSide) -> Stream.of(leftSide, rightSide).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return new JiraIssue(title, description, link, issue, type, linkedIssues, labels, additionalFields);
    }

    private Map<String, Object> getAdditionalField(String json, String fieldPrefix, Map<String, Object> additionalFields, String additionalFieldString) {
        try {
            additionalFields.put(additionalFieldString, JsonPath.read((String)json, (String)(fieldPrefix + additionalFieldString), (Predicate[])new Predicate[0]));
        }
        catch (PathNotFoundException e) {
            LOG.warn("Could not find the additional field", (Throwable)e);
        }
        return additionalFields;
    }

    public abstract JiraClient withBasicCredentials(String var1, String var2);

    public abstract JiraClient withBearer(String var1);

    public abstract JiraClient withTokenCredentials(String var1);

    public abstract JiraClient withHeaders(Map<String, String> var1);

    public abstract Optional<JiraIssue> getIssue(String var1) throws GitChangelogIntegrationException;
}

