/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.git;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import se.bjurr.gitchangelog.internal.git.GitRepoData;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.git.model.GitTag;
import se.bjurr.gitchangelog.internal.model.ParsedIssue;

public final class GitRepoDataHelper {
    public static GitRepoData removeCommitsWithoutIssue(List<ParsedIssue> allParsedIssues, GitRepoData gitRepoData) {
        TreeSet<GitCommit> commitsWithIssues = new TreeSet<GitCommit>();
        for (ParsedIssue parsedIssue : allParsedIssues) {
            for (GitCommit gitCommit : parsedIssue.getGitCommits()) {
                commitsWithIssues.add(gitCommit);
            }
        }
        ArrayList reducedGitCommits = new ArrayList(commitsWithIssues);
        ArrayList<GitTag> reducedGitTags = new ArrayList<GitTag>();
        for (GitTag gitTag : gitRepoData.getGitTags()) {
            List<GitCommit> reducedCommitsInTag = gitTag.getGitCommits().stream().filter(it -> reducedGitCommits.contains(it)).collect(Collectors.toList());
            if (!reducedCommitsInTag.iterator().hasNext()) continue;
            GitTag item = new GitTag(gitTag.getName(), gitTag.findAnnotation().orElse(null), reducedCommitsInTag, gitTag.getTagTime());
            reducedGitTags.add(item);
        }
        String originCloneUrl = gitRepoData.getOriginCloneUrl();
        return new GitRepoData(originCloneUrl, reducedGitTags);
    }

    private GitRepoDataHelper() {
    }
}

