/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.git;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.bjurr.gitchangelog.api.InclusivenessStrategy;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogRepositoryException;
import se.bjurr.gitchangelog.internal.git.GitRepoData;
import se.bjurr.gitchangelog.internal.git.RevisionBoundary;
import se.bjurr.gitchangelog.internal.git.TraversalWork;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.git.model.GitTag;
import se.bjurr.gitchangelog.internal.semantic.SemanticVersion;
import se.bjurr.gitchangelog.internal.semantic.SemanticVersioning;

@SuppressFBWarnings(value={"CRLF_INJECTION_LOGS", "BC_VACUOUS_INSTANCEOF", "BC_UNCONFIRMED_CAST_OF_RETURN_VALUE", "PATH_TRAVERSAL_IN"})
public class GitRepo
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(GitRepo.class);
    private List<RevCommit> commitsToInclude;
    private Git git;
    private final Repository repository;
    private final RevWalk revWalk;
    private List<String> pathFilters = new ArrayList<String>();

    public GitRepo() {
        this.repository = null;
        this.revWalk = null;
    }

    public GitRepo(File repo) throws GitChangelogRepositoryException {
        try {
            FileRepositoryBuilder builder;
            File repoFile = new File(repo.getAbsolutePath());
            File gitRepoFile = new File(repo.getAbsolutePath() + "/.git");
            if (gitRepoFile.exists()) {
                repoFile = gitRepoFile;
            }
            if ((builder = (FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(repoFile)).readEnvironment()).getGitDir() == null) {
                throw new GitChangelogRepositoryException("Did not find a GIT repo in " + repo.getAbsolutePath());
            }
            this.repository = builder.build();
            this.revWalk = new RevWalk(this.repository);
            this.git = new Git(this.repository);
        }
        catch (IOException e) {
            throw new GitChangelogRepositoryException("Could not use GIT repo in " + repo.getAbsolutePath(), e);
        }
    }

    @Override
    public void close() throws IOException {
        this.git.close();
        this.repository.close();
        this.revWalk.dispose();
        if (this.revWalk instanceof AutoCloseable) {
            try {
                this.revWalk.close();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public ObjectId getCommit(String fromCommit) throws GitChangelogRepositoryException {
        if (fromCommit.startsWith("0000000000000000000000000000000000000000")) {
            return this.firstCommit();
        }
        try {
            return this.repository.resolve(fromCommit);
        }
        catch (Exception e) {
            throw new GitChangelogRepositoryException("", e);
        }
    }

    public Optional<RevisionBoundary<ObjectId>> findObjectId(String revision, InclusivenessStrategy inclusivenessStrategy) throws GitChangelogRepositoryException {
        Optional<ObjectId> objectId = this.findRef(revision);
        if (!objectId.isPresent()) {
            objectId = Optional.ofNullable(this.getCommit(revision));
        }
        return objectId.map(id -> new RevisionBoundary<ObjectId>((ObjectId)id, inclusivenessStrategy));
    }

    public GitRepoData getGitRepoData(RevisionBoundary<ObjectId> from, RevisionBoundary<ObjectId> to, String untaggedName, Optional<String> ignoreTagsIfNameMatches) throws GitChangelogRepositoryException {
        try {
            String originUrl = this.git.getRepository().getConfig().getString("remote", "origin", "url");
            List<GitTag> gitTags = this.gitTags(from, to, untaggedName, ignoreTagsIfNameMatches);
            return new GitRepoData(originUrl, gitTags);
        }
        catch (Exception e) {
            throw new GitChangelogRepositoryException(this.toString(), e);
        }
    }

    public ObjectId getRef(String ref) throws GitChangelogRepositoryException {
        try {
            Optional<ObjectId> foundOpt = this.findRef(ref, true);
            if (foundOpt.isPresent()) {
                return foundOpt.get();
            }
            return this.findRef(ref, false).get();
        }
        catch (Exception e) {
            throw new GitChangelogRepositoryException(ref + " not found in:\n" + this.toString(), e);
        }
    }

    public Optional<ObjectId> findRef(String findRef, boolean exact) throws IOException {
        for (Ref foundRef : this.getAllRefs().values()) {
            boolean match = this.isMatching(findRef, exact, foundRef);
            if (!match) continue;
            Ref ref = this.getAllRefs().get(foundRef.getName());
            return this.getPeeledObjectId(ref);
        }
        return Optional.empty();
    }

    private Optional<ObjectId> getPeeledObjectId(Ref ref) throws IOException {
        Ref peeledRef = this.repository.getRefDatabase().peel(ref);
        if (peeledRef.getPeeledObjectId() != null) {
            return Optional.of(peeledRef.getPeeledObjectId());
        }
        return Optional.of(ref.getObjectId());
    }

    private boolean isMatching(String findRef, boolean exact, Ref candidate) {
        String candidateName = candidate.getName();
        if (exact) {
            return candidateName.equalsIgnoreCase(findRef) || candidateName.equalsIgnoreCase("refs/tags/" + findRef) || candidateName.equalsIgnoreCase("refs/heads/" + findRef);
        }
        return candidateName.endsWith(findRef);
    }

    public Optional<ObjectId> findRef(String ref) {
        try {
            return Optional.of(this.getRef(ref));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Ref foundRef : this.getAllRefs().values()) {
            sb.append(foundRef.getName() + "\n");
        }
        return "Repo: " + this.repository + "\n" + sb.toString();
    }

    private boolean addCommitToCurrentTag(Map<String, Set<GitCommit>> commitsPerTagName, String currentTagName, RevCommit thisCommit) {
        GitCommit gitCommit = this.toGitCommit(thisCommit);
        boolean newTagFound = false;
        if (!commitsPerTagName.containsKey(currentTagName)) {
            commitsPerTagName.put(currentTagName, new TreeSet());
            newTagFound = true;
        }
        Set<GitCommit> gitCommitsInCurrentTag = commitsPerTagName.get(currentTagName);
        gitCommitsInCurrentTag.add(gitCommit);
        return newTagFound;
    }

    private void addToTags(Map<String, Set<GitCommit>> commitsPerTag, String tagName, Date tagTime, List<GitTag> addTo, Map<String, RevTag> annotatedTagPerTagName) {
        if (commitsPerTag.containsKey(tagName)) {
            Set<GitCommit> gitCommits = commitsPerTag.get(tagName);
            boolean isAnnotated = annotatedTagPerTagName.containsKey(tagName);
            String annotation = null;
            if (isAnnotated) {
                annotation = annotatedTagPerTagName.get(tagName).getFullMessage();
            }
            GitTag gitTag = new GitTag(tagName, annotation, new ArrayList<GitCommit>(gitCommits), tagTime);
            addTo.add(gitTag);
        }
    }

    private RevCommit firstCommit() {
        RevCommit revCommit;
        Git git = new Git(this.repository);
        try {
            ObjectId head = this.getRef("HEAD");
            Iterator itr = git.log().add((AnyObjectId)head).call().iterator();
            RevCommit last = null;
            while (itr.hasNext()) {
                last = (RevCommit)itr.next();
            }
            revCommit = last;
        }
        catch (Throwable throwable) {
            try {
                try {
                    git.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("First commit not found in " + this.repository.getDirectory(), e);
            }
        }
        git.close();
        return revCommit;
    }

    private Map<String, Ref> getAllRefs() {
        return this.repository.getAllRefs();
    }

    private Map<String, RevTag> getAnnotatedTagPerTagName(Optional<String> ignoreTagsIfNameMatches, List<Ref> tagList) throws IOException {
        TreeMap<String, RevTag> tagPerCommit = new TreeMap<String, RevTag>();
        for (Ref tag : tagList) {
            Ref peeledTag;
            if (ignoreTagsIfNameMatches.isPresent() && Pattern.compile(ignoreTagsIfNameMatches.get()).matcher(tag.getName()).matches() || (peeledTag = this.repository.getRefDatabase().peel(tag)).getPeeledObjectId() == null) continue;
            try {
                RevTag revTag = RevTag.parse((byte[])this.repository.open((AnyObjectId)tag.getObjectId()).getBytes());
                tagPerCommit.put(tag.getName(), revTag);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return tagPerCommit;
    }

    private List<RevCommit> getCommitList(RevWalk revWalk, RevisionBoundary<RevCommit> fromBoundary, RevisionBoundary<RevCommit> toBoundary, List<String> pathFilters) throws Exception {
        RevCommit from = fromBoundary.getRevision();
        RevCommit to = toBoundary.getRevision();
        LogCommand logCommand = this.git.log().addRange((AnyObjectId)from, (AnyObjectId)to);
        if (pathFilters != null && !pathFilters.isEmpty()) {
            for (String pathFilter : pathFilters) {
                logCommand.addPath(pathFilter);
            }
        }
        ArrayList<RevCommit> list = new ArrayList<RevCommit>();
        for (RevCommit commit : logCommand.call()) {
            list.add(commit);
        }
        if (fromBoundary.getInclusivenessStrategy() == InclusivenessStrategy.DEFAULT) {
            revWalk.parseHeaders((RevObject)from);
            if (from.getParentCount() == 0) {
                list.add(from);
            }
        }
        if (fromBoundary.getInclusivenessStrategy() == InclusivenessStrategy.INCLUSIVE) {
            list.add(from);
        }
        if (toBoundary.getInclusivenessStrategy() == InclusivenessStrategy.EXCLUSIVE) {
            list.remove(to);
        }
        return list;
    }

    private boolean hasPathFilter() {
        return this.pathFilters != null && !this.pathFilters.isEmpty();
    }

    private ObjectId getPeeled(Ref tag) throws IOException {
        Ref peeledTag = this.repository.getRefDatabase().peel(tag);
        if (peeledTag.getPeeledObjectId() != null) {
            return peeledTag.getPeeledObjectId();
        }
        return tag.getObjectId();
    }

    private List<Ref> getTagCommitHashSortedByCommitTime(Collection<Ref> refs) {
        return refs.stream().sorted((o1, o2) -> {
            try {
                RevCommit revCommit1 = this.revWalk.lookupCommit((AnyObjectId)this.getPeeled((Ref)o1));
                this.revWalk.parseHeaders((RevObject)revCommit1);
                RevCommit revCommit2 = this.revWalk.lookupCommit((AnyObjectId)this.getPeeled((Ref)o2));
                this.revWalk.parseHeaders((RevObject)revCommit2);
                return this.toGitCommit(revCommit1).compareTo(this.toGitCommit(revCommit2));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }).collect(Collectors.toList());
    }

    private String getTagName(Map<String, Ref> tagPerCommitHash, String thisCommitHash) {
        return tagPerCommitHash.get(thisCommitHash).getName();
    }

    private Map<String, Ref> getTagPerCommitHash(Optional<String> ignoreTagsIfNameMatches, List<Ref> tagList) throws IOException {
        TreeMap<String, Ref> tagPerCommit = new TreeMap<String, Ref>();
        for (Ref tag : tagList) {
            if (ignoreTagsIfNameMatches.isPresent() && Pattern.compile(ignoreTagsIfNameMatches.get()).matcher(tag.getName()).matches()) continue;
            String commitId = this.getPeeled(tag).getName();
            if (tagPerCommit.containsKey(commitId)) {
                boolean existingTagNotSemantic;
                boolean newFoundTagSemantic = SemanticVersioning.isSemantic(tag.getName());
                boolean bl = existingTagNotSemantic = !SemanticVersioning.isSemantic(((Ref)tagPerCommit.get(commitId)).getName());
                if (!newFoundTagSemantic && !existingTagNotSemantic) continue;
                tagPerCommit.put(commitId, tag);
                continue;
            }
            tagPerCommit.put(commitId, tag);
        }
        return tagPerCommit;
    }

    private List<GitTag> gitTags(RevisionBoundary<ObjectId> fromObjectId, RevisionBoundary<ObjectId> toObjectId, String untaggedName, Optional<String> ignoreTagsIfNameMatches) throws Exception {
        RevisionBoundary<RevCommit> from = this.toRevCommit(fromObjectId);
        RevisionBoundary<RevCommit> to = this.toRevCommit(toObjectId);
        this.commitsToInclude = this.getCommitList(this.revWalk, from, to, this.pathFilters);
        List<Ref> tagList = this.tagsBetweenFromAndTo(from, to);
        Map<String, Ref> tagPerCommitHash = this.getTagPerCommitHash(ignoreTagsIfNameMatches, tagList);
        Map<String, RevTag> annotatedTagPerTagName = this.getAnnotatedTagPerTagName(ignoreTagsIfNameMatches, tagList);
        TreeMap<String, String> tagPerCommitsHash = new TreeMap<String, String>();
        HashMap<String, Set<GitCommit>> commitsPerTag = new HashMap<String, Set<GitCommit>>();
        TreeMap<String, Date> datePerTag = new TreeMap<String, Date>();
        this.populateComitPerTag(from.getRevision(), to.getRevision(), tagPerCommitHash, tagPerCommitsHash, commitsPerTag, datePerTag, null);
        this.populateComitPerTag(from.getRevision(), to.getRevision(), tagPerCommitHash, tagPerCommitsHash, commitsPerTag, datePerTag, untaggedName);
        if (this.hasPathFilter()) {
            this.pruneCommitsPerTag(commitsPerTag);
        }
        ArrayList<GitTag> tags = new ArrayList<GitTag>();
        this.addToTags(commitsPerTag, untaggedName, null, tags, annotatedTagPerTagName);
        List<Ref> tagCommitHashSortedByCommitTime = this.getTagCommitHashSortedByCommitTime(tagPerCommitHash.values());
        for (Ref tag : tagCommitHashSortedByCommitTime) {
            this.addToTags(commitsPerTag, tag.getName(), (Date)datePerTag.get(tag.getName()), tags, annotatedTagPerTagName);
        }
        return tags;
    }

    private RevisionBoundary<RevCommit> toRevCommit(RevisionBoundary<ObjectId> fromObjectId) {
        return new RevisionBoundary<RevCommit>(this.revWalk.lookupCommit((AnyObjectId)fromObjectId.getRevision()), fromObjectId.getInclusivenessStrategy());
    }

    private void pruneCommitsPerTag(Map<String, Set<GitCommit>> commitsPerTag) {
        Set toIncludeSet = this.commitsToInclude.stream().map(AnyObjectId::name).collect(Collectors.toSet());
        ArrayList tagsToRemove = new ArrayList();
        commitsPerTag.forEach((tag, commits) -> {
            List removeList = commits.stream().filter(c -> !toIncludeSet.contains(c.getHash())).collect(Collectors.toList());
            commits.removeAll(removeList);
            if (commits.size() == 0) {
                tagsToRemove.add(tag);
            }
        });
        tagsToRemove.forEach(commitsPerTag::remove);
    }

    private boolean isMappedToAnotherTag(Map<String, String> tagPerCommitsHash, String thisCommitHash, String thisTagName) {
        String existingTagName = tagPerCommitsHash.get(thisCommitHash);
        if (existingTagName == null) {
            return false;
        }
        return GitRepo.isFirstTagSemanticallyHighest(thisTagName, existingTagName);
    }

    private String noteThatTheCommitWasMapped(Map<String, String> tagPerCommitsHash, String currentTagName, String thisCommitHash) {
        return tagPerCommitsHash.put(thisCommitHash, currentTagName);
    }

    private boolean notFirstIncludedCommit(ObjectId from, ObjectId to) {
        return !from.getName().equals(to.getName());
    }

    private void populateComitPerTag(RevCommit from, RevCommit to, Map<String, Ref> tagPerCommitHash, Map<String, String> tagPerCommitsHash, Map<String, Set<GitCommit>> commitsPerTag, Map<String, Date> datePerTag, String startingTagName) throws Exception {
        RevCommit thisCommit = this.revWalk.lookupCommit((AnyObjectId)to);
        this.revWalk.parseHeaders((RevObject)thisCommit);
        PriorityQueue<TraversalWork> moreWork = new PriorityQueue<TraversalWork>();
        moreWork.add(new TraversalWork(to, startingTagName));
        do {
            TraversalWork next = (TraversalWork)moreWork.remove();
            this.populateCommitPerTag(from, next.getTo(), commitsPerTag, tagPerCommitHash, tagPerCommitsHash, datePerTag, next.getCurrentTagName(), moreWork);
            LOG.debug("Work left: " + moreWork.size());
        } while (!moreWork.isEmpty());
    }

    private void populateCommitPerTag(RevCommit from, RevCommit to, Map<String, Set<GitCommit>> commitsPerTagName, Map<String, Ref> tagPerCommitHash, Map<String, String> tagPerCommitsHash, Map<String, Date> datePerTag, String currentTagName, PriorityQueue<TraversalWork> moreWork) throws Exception {
        String thisCommitHash = to.getName();
        if (this.isMappedToAnotherTag(tagPerCommitsHash, thisCommitHash, currentTagName)) {
            return;
        }
        if (this.thisIsANewTag(tagPerCommitHash, thisCommitHash)) {
            currentTagName = this.getTagName(tagPerCommitHash, thisCommitHash);
        }
        if (currentTagName != null && this.shouldInclude(to)) {
            if (this.addCommitToCurrentTag(commitsPerTagName, currentTagName, to)) {
                datePerTag.put(currentTagName, new Date((long)to.getCommitTime() * 1000L));
            }
            this.noteThatTheCommitWasMapped(tagPerCommitsHash, currentTagName, thisCommitHash);
        }
        if (this.notFirstIncludedCommit((ObjectId)from, (ObjectId)to)) {
            for (RevCommit parent : to.getParents()) {
                if (!this.shouldInclude(parent)) continue;
                this.revWalk.parseHeaders((RevObject)parent);
                TraversalWork work = new TraversalWork(parent, currentTagName);
                Optional<TraversalWork> existingWorkOpt = moreWork.stream().filter(it -> it.getTo().equals((AnyObjectId)parent)).findFirst();
                if (existingWorkOpt.isPresent()) {
                    if (!this.shouldPrioritizeNewWork(existingWorkOpt.get(), work)) continue;
                    moreWork.remove(existingWorkOpt.get());
                    moreWork.add(work);
                    continue;
                }
                moreWork.add(work);
            }
        }
    }

    private boolean shouldPrioritizeNewWork(TraversalWork existingWork, TraversalWork newWork) {
        String existingTagName = existingWork.getCurrentTagName();
        String newTagName = newWork.getCurrentTagName();
        return GitRepo.isFirstTagSemanticallyHighest(existingTagName, newTagName);
    }

    static boolean isFirstTagSemanticallyHighest(String firstTagName, String secondTagName) {
        if (firstTagName == null && secondTagName == null) {
            return false;
        }
        if (firstTagName == null && secondTagName != null) {
            return true;
        }
        if (secondTagName == null) {
            return false;
        }
        if (firstTagName.equals(secondTagName)) {
            return false;
        }
        boolean newTagIsSemantic = SemanticVersioning.isSemantic(secondTagName);
        if (newTagIsSemantic) {
            boolean existingTagNameIsSemantic = SemanticVersioning.isSemantic(firstTagName);
            if (!existingTagNameIsSemantic) {
                return true;
            }
            SemanticVersion highest = SemanticVersioning.getHighestVersion(Arrays.asList(firstTagName, secondTagName));
            if (highest.findTag().orElse("").equals(firstTagName)) {
                return true;
            }
        }
        return false;
    }

    private boolean shouldInclude(RevCommit candidate) throws Exception {
        return this.hasPathFilter() || this.commitsToInclude.contains(candidate);
    }

    private List<Ref> tagsBetweenFromAndTo(RevisionBoundary<RevCommit> from, RevisionBoundary<RevCommit> to) throws Exception {
        List tagList = this.git.tagList().call();
        List<RevCommit> icludedCommits = this.getCommitList(this.revWalk, from, to, null);
        ArrayList<Ref> includedTags = new ArrayList<Ref>();
        for (Ref tag : tagList) {
            ObjectId peeledTag = this.getPeeled(tag);
            if (!icludedCommits.contains(peeledTag)) continue;
            includedTags.add(tag);
        }
        return includedTags;
    }

    private boolean thisIsANewTag(Map<String, Ref> tagsPerCommitHash, String thisCommitHash) {
        return tagsPerCommitHash.containsKey(thisCommitHash);
    }

    private GitCommit toGitCommit(RevCommit revCommit) {
        Boolean merge = revCommit.getParentCount() > 1;
        return new GitCommit(revCommit.getAuthorIdent().getName(), revCommit.getAuthorIdent().getEmailAddress(), new Date((long)revCommit.getCommitTime() * 1000L), revCommit.getFullMessage(), revCommit.getId().getName(), merge);
    }

    public void setPathFilters(List<String> pathFilters) {
        this.pathFilters = pathFilters;
    }

    public List<String> getTags(RevisionBoundary<ObjectId> fromObjectId, RevisionBoundary<ObjectId> toObjectId) throws Exception {
        RevisionBoundary<RevCommit> from = this.toRevCommit(fromObjectId);
        RevisionBoundary<RevCommit> to = this.toRevCommit(toObjectId);
        ArrayList<String> tags = new ArrayList<String>();
        for (Ref tagRef : this.tagsBetweenFromAndTo(from, to)) {
            String commitIdOfRef = this.getPeeled(tagRef).name();
            if (!commitIdOfRef.equals(to.getRevision().getName())) continue;
            tags.add(tagRef.getName());
        }
        return tags;
    }
}

