/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api.model;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import se.bjurr.gitchangelog.api.model.Author;
import se.bjurr.gitchangelog.api.model.Commit;
import se.bjurr.gitchangelog.api.model.interfaces.IAuthors;
import se.bjurr.gitchangelog.api.model.interfaces.ICommits;
import se.bjurr.gitchangelog.internal.settings.SettingsIssueType;
import se.bjurr.gitchangelog.internal.util.Preconditions;

public class Issue
implements ICommits,
IAuthors,
Serializable {
    private static final long serialVersionUID = -7571341639024417199L;
    private final List<Commit> commits;
    private final List<Author> authors;
    private final String name;
    private final String title;
    private final boolean hasTitle;
    private final String issue;
    private final boolean hasIssue;
    private final String link;
    private final boolean hasLink;
    private final String type;
    private final boolean hasType;
    private final boolean hasDescription;
    private final String description;
    private final List<String> labels;
    private final boolean hasLabels;
    private final boolean hasLinkedIssues;
    private final SettingsIssueType issueType;
    private final List<String> linkedIssues;
    private final boolean hasAdditionalFields;
    private final Map<String, Object> additionalFields;

    public Issue(List<Commit> commits, List<Author> authors, String name, String title, String issue, SettingsIssueType issueType, String description, String link, String type, List<String> linkedIssues, List<String> labels, Map<String, Object> additionalFields) {
        Preconditions.checkState(!commits.isEmpty(), "commits");
        this.commits = commits;
        this.authors = Preconditions.checkNotNull(authors, "authors");
        this.name = Preconditions.checkNotNull(name, "name");
        this.title = Preconditions.nullToEmpty(title);
        this.hasTitle = !Preconditions.isNullOrEmpty(title);
        this.description = Preconditions.nullToEmpty(description);
        this.hasDescription = !Preconditions.isNullOrEmpty(description);
        this.issue = Preconditions.nullToEmpty(issue);
        this.issueType = Preconditions.checkNotNull(issueType, "issueType");
        this.hasIssue = !Preconditions.isNullOrEmpty(issue);
        this.link = Preconditions.nullToEmpty(link);
        this.hasLink = !Preconditions.isNullOrEmpty(link);
        this.hasType = !Preconditions.isNullOrEmpty(type);
        this.type = Preconditions.nullToEmpty(type);
        this.hasLabels = labels != null && !labels.isEmpty();
        this.hasLinkedIssues = linkedIssues != null && !linkedIssues.isEmpty();
        this.linkedIssues = linkedIssues;
        this.labels = labels;
        this.hasAdditionalFields = additionalFields != null && !additionalFields.isEmpty();
        this.additionalFields = additionalFields;
    }

    public SettingsIssueType getIssueType() {
        return this.issueType;
    }

    public boolean isJira() {
        return this.issueType == SettingsIssueType.JIRA;
    }

    public boolean isRedmine() {
        return this.issueType == SettingsIssueType.REDMINE;
    }

    public boolean isGitHub() {
        return this.issueType == SettingsIssueType.GITHUB;
    }

    public boolean isGitLab() {
        return this.issueType == SettingsIssueType.GITLAB;
    }

    public boolean isCustom() {
        return this.issueType == SettingsIssueType.CUSTOM;
    }

    public boolean isNoIssue() {
        return this.issueType == SettingsIssueType.NOISSUE;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean getHasTitle() {
        return this.hasTitle;
    }

    public boolean getHasIssue() {
        return this.hasIssue;
    }

    public boolean getHasLabels() {
        return this.hasLabels;
    }

    public boolean getHasType() {
        return this.hasType;
    }

    public boolean getHasLink() {
        return this.hasLink;
    }

    public String getIssue() {
        return this.issue;
    }

    public String getLink() {
        return this.link;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean getHasDescription() {
        return this.hasDescription;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public List<Author> getAuthors() {
        return this.authors;
    }

    @Override
    public List<Commit> getCommits() {
        return this.commits;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public List<String> getLinkedIssues() {
        return this.linkedIssues;
    }

    public boolean getHasLinkedIssues() {
        return this.hasLinkedIssues;
    }

    public boolean getHasAdditionalFields() {
        return this.hasAdditionalFields;
    }

    public Map<String, Object> getAdditionalFields() {
        return this.additionalFields;
    }

    public String toString() {
        return "Issue: " + this.issue + " Title: " + this.title;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authors == null ? 0 : this.authors.hashCode());
        result = 31 * result + (this.commits == null ? 0 : this.commits.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.hasDescription ? 1231 : 1237);
        result = 31 * result + (this.hasIssue ? 1231 : 1237);
        result = 31 * result + (this.hasLabels ? 1231 : 1237);
        result = 31 * result + (this.hasLink ? 1231 : 1237);
        result = 31 * result + (this.hasLinkedIssues ? 1231 : 1237);
        result = 31 * result + (this.hasTitle ? 1231 : 1237);
        result = 31 * result + (this.hasType ? 1231 : 1237);
        result = 31 * result + (this.hasAdditionalFields ? 1231 : 1237);
        result = 31 * result + (this.issue == null ? 0 : this.issue.hashCode());
        result = 31 * result + (this.issueType == null ? 0 : this.issueType.hashCode());
        result = 31 * result + (this.labels == null ? 0 : this.labels.hashCode());
        result = 31 * result + (this.link == null ? 0 : this.link.hashCode());
        result = 31 * result + (this.linkedIssues == null ? 0 : this.linkedIssues.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.additionalFields == null ? 0 : this.additionalFields.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Issue other = (Issue)obj;
        if (this.authors == null ? other.authors != null : !this.authors.equals(other.authors)) {
            return false;
        }
        if (this.commits == null ? other.commits != null : !this.commits.equals(other.commits)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.hasDescription != other.hasDescription) {
            return false;
        }
        if (this.hasIssue != other.hasIssue) {
            return false;
        }
        if (this.hasLabels != other.hasLabels) {
            return false;
        }
        if (this.hasLink != other.hasLink) {
            return false;
        }
        if (this.hasLinkedIssues != other.hasLinkedIssues) {
            return false;
        }
        if (this.hasTitle != other.hasTitle) {
            return false;
        }
        if (this.hasType != other.hasType) {
            return false;
        }
        if (this.hasAdditionalFields != other.hasAdditionalFields) {
            return false;
        }
        if (this.issue == null ? other.issue != null : !this.issue.equals(other.issue)) {
            return false;
        }
        if (this.issueType != other.issueType) {
            return false;
        }
        if (this.labels == null ? other.labels != null : !this.labels.equals(other.labels)) {
            return false;
        }
        if (this.link == null ? other.link != null : !this.link.equals(other.link)) {
            return false;
        }
        if (this.linkedIssues == null ? other.linkedIssues != null : !this.linkedIssues.equals(other.linkedIssues)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.additionalFields == null ? other.additionalFields != null : !this.additionalFields.equals(other.additionalFields));
    }
}

