/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.util;

import com.google.inject.Injector;
import com.google.inject.Key;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.testing.DropwizardTestSupport;
import ru.vyarus.dropwizard.guice.test.GuiceyTestSupport;

public class RunResult<C extends Configuration> {
    private final DropwizardTestSupport<C> support;
    private final Injector injector;

    public RunResult(DropwizardTestSupport<C> support, Injector injector) {
        this.support = support;
        this.injector = injector;
    }

    public DropwizardTestSupport<C> getSupport() {
        return this.support;
    }

    public Injector getInjector() {
        return this.injector;
    }

    public Application<C> getApplication() {
        return this.support.getApplication();
    }

    public Environment getEnvironment() {
        return this.support.getEnvironment();
    }

    public C getConfiguration() {
        return (C)this.support.getConfiguration();
    }

    public <T> T getBean(Class<T> type) {
        return this.getBean(Key.get(type));
    }

    public <T> T getBean(Key<T> key) {
        return (T)this.injector.getInstance(key);
    }

    public boolean isWebRun() {
        return !(this.support instanceof GuiceyTestSupport);
    }
}

