/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.util;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.platform.commons.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.GuiceyExtensionsSupport;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.ExtensionConfig;
import ru.vyarus.dropwizard.guice.test.util.StoredReusableApp;

public final class ReusableAppUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReusableAppUtils.class);

    private ReusableAppUtils() {
    }

    public static Class<?> findDeclarationClass(Class<?> test, Annotation ann) {
        Class<? extends Annotation> annType = ann.annotationType();
        Class<?> decl = null;
        for (Class<?> sup = test; decl == null && sup != null && !Object.class.equals(sup); sup = sup.getSuperclass()) {
            Annotation cand = sup.getDeclaredAnnotation(annType);
            if (cand == null || !cand.equals(ann)) continue;
            decl = sup;
        }
        Preconditions.checkNotNull(decl, (String)"Failed to find declaration class for @%s in test class %s hierarchy", (Object)ann.annotationType().getSimpleName(), (Object)test.getName());
        ReusableAppUtils.validateDeclaringClass(test, decl, test.getName() + " (@" + annType.getSimpleName() + ")");
        return decl;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"})
    public static Field findExtensionField(Class<?> test, GuiceyExtensionsSupport ext) {
        List fields = ReflectionUtils.findFields(test, field -> Modifier.isStatic(field.getModifiers()) && field.isAnnotationPresent(RegisterExtension.class), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.BOTTOM_UP);
        Field target = null;
        for (Field field2 : fields) {
            try {
                Object value = ReflectionUtils.tryToReadFieldValue((Field)field2).get();
                if (value == null || !value.equals(ext)) continue;
                target = field2;
                break;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to read field value: " + field2.getName(), ex);
            }
        }
        Preconditions.checkNotNull(target, (String)"Failed to find declaration field for %s extension in test class %s hierarchy. Probably, reusable app declared in non-static field.", (Object)ext.getClass().getSimpleName(), (Object)test.getName());
        Class<?> declaringClass = target.getDeclaringClass();
        ReusableAppUtils.validateDeclaringClass(test, declaringClass, declaringClass.getName() + "." + target.getName());
        return target;
    }

    public static void registerField(Class<?> test, GuiceyExtensionsSupport ext, ExtensionConfig config) {
        Field field = ReusableAppUtils.findExtensionField(test, ext);
        config.reuseDeclarationClass = field.getDeclaringClass();
        config.reuseSource = field.getDeclaringClass().getName() + "." + field.getName();
    }

    public static void registerAnnotation(Class<?> test, Annotation ann, ExtensionConfig config) {
        Class<?> declare = ReusableAppUtils.findDeclarationClass(test, ann);
        config.reuseDeclarationClass = declare;
        config.reuseSource = declare.getName() + "@" + ann.annotationType().getSimpleName();
    }

    public static ExtensionContext.Store getGlobalStore(ExtensionContext context) {
        return context.getRoot().getStore(ExtensionContext.Namespace.create((Object[])new Object[]{GuiceyExtensionsSupport.class}));
    }

    public static synchronized StoredReusableApp getGlobalApp(ExtensionContext context, Class<?> declarationClass) {
        ExtensionContext.Store global = ReusableAppUtils.getGlobalStore(context);
        return (StoredReusableApp)global.get((Object)ReusableAppUtils.getKey(declarationClass));
    }

    public static synchronized void registerGlobalApp(ExtensionContext context, StoredReusableApp app) {
        String key;
        ExtensionContext.Store globalStore = ReusableAppUtils.getGlobalStore(context);
        if (globalStore.get((Object)(key = ReusableAppUtils.getKey(app.getDeclaration()))) != null) {
            throw new IllegalStateException(String.format("Can't register reusable application %s because another application %s is already registered for base class %s", app.getSource(), ((StoredReusableApp)globalStore.get((Object)key)).getSource(), app.getDeclaration().getName()));
        }
        globalStore.put((Object)key, (Object)app);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean closeGlobalApp(ExtensionContext context, Class<?> declarationClass) {
        StoredReusableApp app = ReusableAppUtils.getGlobalApp(context, declarationClass);
        if (app != null) {
            LOGGER.warn("Requested manual close for reusable app {}", (Object)app.getSource());
            try {
                app.close();
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                LOGGER.error("Error closing reusable app manually", (Throwable)e);
            }
            finally {
                ReusableAppUtils.getGlobalStore(context).remove((Object)ReusableAppUtils.getKey(declarationClass));
            }
        }
        return false;
    }

    private static void validateDeclaringClass(Class<?> test, Class<?> declaration, String source) {
        Preconditions.checkState((!test.equals(declaration) ? 1 : 0) != 0, (String)"Application declared in %s can't be reused because reusable declaration must be in abstract (base) class so tests could share the same declaration", (Object)source);
    }

    private static String getKey(Class<?> declarationClass) {
        return declarationClass.getName();
    }
}

